/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.RyuDouble;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONWriterUTF16
extends JSONWriter {
    static final char[] REF_PREF = "{\"$ref\":".toCharArray();
    protected char[] chars;
    final JSONFactory.CacheItem cacheItem;

    JSONWriterUTF16(JSONWriter.Context ctx) {
        super(ctx, null, false, StandardCharsets.UTF_16);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        this.chars = JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
        if (this.chars == null) {
            this.chars = new char[8192];
        }
    }

    @Override
    public final void flushTo(Writer to) {
        try {
            if (this.off > 0) {
                to.write(this.chars, 0, this.off);
                this.off = 0;
            }
        }
        catch (IOException e) {
            throw new JSONException("flushTo error", e);
        }
    }

    @Override
    public final void close() {
        if (this.chars.length > 0x100000) {
            return;
        }
        JSONFactory.CHARS_UPDATER.lazySet(this.cacheItem, this.chars);
    }

    @Override
    protected final void write0(char c) {
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = c;
    }

    @Override
    public final void writeColon() {
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 58;
    }

    @Override
    public final void startObject() {
        ++this.level;
        this.startObject = true;
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 123;
    }

    @Override
    public final void endObject() {
        --this.level;
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 125;
        this.startObject = false;
    }

    @Override
    public final void writeComma() {
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 44;
    }

    @Override
    public final void startArray() {
        ++this.level;
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 91;
    }

    @Override
    public final void endArray() {
        --this.level;
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeString(List<String> list) {
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 91;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (this.off == this.chars.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.chars[this.off++] = 44;
            }
            String str = list.get(i);
            this.writeString(str);
        }
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 93;
    }

    @Override
    protected void writeStringLatin1(byte[] value) {
        if (value == null) {
            this.writeStringNull();
            return;
        }
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escape = false;
        int minCapacity = this.off + value.length + 2;
        if (minCapacity - this.chars.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        int mark = this.off;
        this.chars[this.off++] = this.quote;
        for (int i = 0; i < value.length; ++i) {
            byte c = value[i];
            if (c == 92 || c == this.quote || c < 32) {
                escape = true;
                break;
            }
            if (browserSecure && (c == 60 || c == 62 || c == 40 || c == 41)) {
                escape = true;
                break;
            }
            this.chars[this.off++] = (char)c;
        }
        if (!escape) {
            this.chars[this.off++] = this.quote;
            return;
        }
        this.off = mark;
        this.writeStringEscape(value);
    }

    @Override
    public void writeString(String str) {
        char c3;
        char c2;
        char c1;
        char c0;
        int coder;
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean escape = false;
        if (JDKUtils.STRING_VALUE != null && (coder = JDKUtils.STRING_CODER.applyAsInt(str)) == 0) {
            byte[] value = JDKUtils.STRING_VALUE.apply(str);
            int minCapacity = this.off + value.length + 2;
            if (minCapacity - this.chars.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            int mark = this.off;
            this.chars[this.off++] = this.quote;
            for (int i = 0; i < value.length; ++i) {
                byte c = value[i];
                if (c == 92 || c == this.quote || c < 32) {
                    escape = true;
                    break;
                }
                if (browserSecure && (c == 60 || c == 62 || c == 40 || c == 41)) {
                    escape = true;
                    break;
                }
                this.chars[this.off++] = (char)c;
            }
            if (!escape) {
                this.chars[this.off++] = this.quote;
                return;
            }
            this.off = mark;
        }
        int strlen = str.length();
        int i = 0;
        while (i + 8 <= strlen) {
            c0 = str.charAt(i);
            c1 = str.charAt(i + 1);
            c2 = str.charAt(i + 2);
            c3 = str.charAt(i + 3);
            char c4 = str.charAt(i + 4);
            char c5 = str.charAt(i + 5);
            char c6 = str.charAt(i + 6);
            char c7 = str.charAt(i + 7);
            if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c4 == '\\' || c5 == '\\' || c6 == '\\' || c7 == '\\' || c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ' || c4 < ' ' || c5 < ' ' || c6 < ' ' || c7 < ' ') {
                escape = true;
                break;
            }
            if (browserSecure && (c0 == '<' || c1 == '<' || c2 == '<' || c3 == '<' || c4 == '<' || c5 == '<' || c6 == '<' || c7 == '<' || c0 == '>' || c1 == '>' || c2 == '>' || c3 == '>' || c4 == '>' || c5 == '>' || c6 == '>' || c7 == '>' || c0 == '(' || c1 == '(' || c2 == '(' || c3 == '(' || c4 == '(' || c5 == '(' || c6 == '(' || c7 == '(' || c0 == ')' || c1 == ')' || c2 == ')' || c3 == ')' || c4 == ')' || c5 == ')' || c6 == ')' || c7 == ')')) {
                escape = true;
                break;
            }
            if (escapeNoneAscii && (c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f' || c4 > '\u007f' || c5 > '\u007f' || c6 > '\u007f' || c7 > '\u007f')) {
                escape = true;
                break;
            }
            i += 8;
        }
        if (!escape) {
            while (i + 4 <= strlen) {
                c0 = str.charAt(i);
                c1 = str.charAt(i + 1);
                c2 = str.charAt(i + 2);
                c3 = str.charAt(i + 3);
                if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\' || c0 < ' ' || c1 < ' ' || c2 < ' ' || c3 < ' ') {
                    escape = true;
                    break;
                }
                if (browserSecure && (c0 == '<' || c1 == '<' || c2 == '<' || c3 == '<' || c0 == '>' || c1 == '>' || c2 == '>' || c3 == '>' || c0 == '(' || c1 == '(' || c2 == '(' || c3 == '(' || c0 == ')' || c1 == ')' || c2 == ')' || c3 == ')')) {
                    escape = true;
                    break;
                }
                if (escapeNoneAscii && (c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f')) {
                    escape = true;
                    break;
                }
                i += 4;
            }
        }
        if (!escape && i + 2 <= strlen) {
            c0 = str.charAt(i);
            c1 = str.charAt(i + 1);
            if (c0 == this.quote || c1 == this.quote || c0 == '\\' || c1 == '\\' || c0 < ' ' || c1 < ' ') {
                escape = true;
            } else if (browserSecure && (c0 == '<' || c1 == '<' || c0 == '>' || c1 == '>' || c0 == '(' || c1 == '(') || c0 == ')' || c1 == ')') {
                escape = true;
            } else if (escapeNoneAscii && (c0 > '\u007f' || c1 > '\u007f')) {
                escape = true;
            } else {
                i += 2;
            }
        }
        if (!escape && i + 1 == strlen) {
            c0 = str.charAt(i);
            boolean bl = escape = c0 == '\"' || c0 == '\\' || c0 < ' ' || escapeNoneAscii && c0 > '\u007f' || browserSecure && (c0 == '<' || c0 == '>' || c0 == '(' || c0 == ')');
        }
        if (!escape) {
            int minCapacity = this.off + strlen + 2;
            if (minCapacity - this.chars.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.chars[this.off++] = this.quote;
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
            this.chars[this.off++] = this.quote;
            return;
        }
        this.writeStringEscape(str);
    }

    protected final void writeStringEscape(String str) {
        int strlen = str.length();
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        this.ensureCapacity(this.off + strlen * 6 + 2);
        this.chars[this.off++] = this.quote;
        block14: for (int i = 0; i < strlen; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == this.quote) {
                        this.chars[this.off++] = 92;
                    }
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                case '\\': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                case '\r': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 114;
                    continue block14;
                }
                case '\n': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 110;
                    continue block14;
                }
                case '\b': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 98;
                    continue block14;
                }
                case '\f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 102;
                    continue block14;
                }
                case '\t': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 116;
                    continue block14;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(48 + ch);
                    continue block14;
                }
                case '\u000b': 
                case '\u000e': 
                case '\u000f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(97 + (ch - 10));
                    continue block14;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(48 + (ch - 16));
                    continue block14;
                }
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(97 + (ch - 26));
                    continue block14;
                }
                case '(': 
                case ')': 
                case '<': 
                case '>': {
                    if (browserSecure && (ch == '<' || ch == '>' || ch == '(' || ch == ')')) {
                        this.chars[this.off++] = 92;
                        this.chars[this.off++] = 117;
                        this.chars[this.off++] = DIGITS[ch >>> 12 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 8 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 4 & 0xF];
                        this.chars[this.off++] = DIGITS[ch & 0xF];
                        continue block14;
                    }
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        this.chars[this.off++] = 92;
                        this.chars[this.off++] = 117;
                        this.chars[this.off++] = DIGITS[ch >>> 12 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 8 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 4 & 0xF];
                        this.chars[this.off++] = DIGITS[ch & 0xF];
                        continue block14;
                    }
                    this.chars[this.off++] = ch;
                }
            }
        }
        this.chars[this.off++] = this.quote;
    }

    protected final void writeStringEscape(char[] str) {
        int strlen = str.length;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        this.ensureCapacity(this.off + strlen * 6 + 2);
        this.chars[this.off++] = this.quote;
        block14: for (int i = 0; i < strlen; ++i) {
            char ch = str[i];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == this.quote) {
                        this.chars[this.off++] = 92;
                    }
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                case '\\': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                case '\r': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 114;
                    continue block14;
                }
                case '\n': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 110;
                    continue block14;
                }
                case '\b': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 98;
                    continue block14;
                }
                case '\f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 102;
                    continue block14;
                }
                case '\t': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 116;
                    continue block14;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(48 + ch);
                    continue block14;
                }
                case '\u000b': 
                case '\u000e': 
                case '\u000f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(97 + (ch - 10));
                    continue block14;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(48 + (ch - 16));
                    continue block14;
                }
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(97 + (ch - 26));
                    continue block14;
                }
                case '(': 
                case ')': 
                case '<': 
                case '>': {
                    if (browserSecure && (ch == '<' || ch == '>' || ch == '(' || ch == ')')) {
                        this.chars[this.off++] = 92;
                        this.chars[this.off++] = 117;
                        this.chars[this.off++] = DIGITS[ch >>> 12 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 8 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 4 & 0xF];
                        this.chars[this.off++] = DIGITS[ch & 0xF];
                        continue block14;
                    }
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        this.chars[this.off++] = 92;
                        this.chars[this.off++] = 117;
                        this.chars[this.off++] = DIGITS[ch >>> 12 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 8 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 4 & 0xF];
                        this.chars[this.off++] = DIGITS[ch & 0xF];
                        continue block14;
                    }
                    this.chars[this.off++] = ch;
                }
            }
        }
        this.chars[this.off++] = this.quote;
    }

    protected final void writeStringEscape(byte[] str) {
        int strlen = str.length;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        this.ensureCapacity(this.off + strlen * 6 + 2);
        this.chars[this.off++] = this.quote;
        block14: for (int i = 0; i < strlen; ++i) {
            char ch = (char)(str[i] & 0xFF);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == this.quote) {
                        this.chars[this.off++] = 92;
                    }
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                case '\\': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                case '\r': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 114;
                    continue block14;
                }
                case '\n': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 110;
                    continue block14;
                }
                case '\b': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 98;
                    continue block14;
                }
                case '\f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 102;
                    continue block14;
                }
                case '\t': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 116;
                    continue block14;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(48 + ch);
                    continue block14;
                }
                case '\u000b': 
                case '\u000e': 
                case '\u000f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(97 + (ch - 10));
                    continue block14;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(48 + (ch - 16));
                    continue block14;
                }
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(97 + (ch - 26));
                    continue block14;
                }
                case '(': 
                case ')': 
                case '<': 
                case '>': {
                    if (browserSecure && (ch == '<' || ch == '>' || ch == '(' || ch == ')')) {
                        this.chars[this.off++] = 92;
                        this.chars[this.off++] = 117;
                        this.chars[this.off++] = DIGITS[ch >>> 12 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 8 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 4 & 0xF];
                        this.chars[this.off++] = DIGITS[ch & 0xF];
                        continue block14;
                    }
                    this.chars[this.off++] = ch;
                    continue block14;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        this.chars[this.off++] = 92;
                        this.chars[this.off++] = 117;
                        this.chars[this.off++] = DIGITS[ch >>> 12 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 8 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 4 & 0xF];
                        this.chars[this.off++] = DIGITS[ch & 0xF];
                        continue block14;
                    }
                    this.chars[this.off++] = ch;
                }
            }
        }
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeString(char[] str, int offset, int len, boolean quote) {
        int minCapacity;
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int n = minCapacity = quote ? this.off + 2 : this.off;
        minCapacity = escapeNoneAscii ? (minCapacity += len * 6) : (minCapacity += len * 2);
        if (minCapacity - this.chars.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (quote) {
            this.chars[this.off++] = this.quote;
        }
        block13: for (int i = offset; i < len; ++i) {
            char ch = str[i];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == this.quote) {
                        this.chars[this.off++] = 92;
                    }
                    this.chars[this.off++] = ch;
                    continue block13;
                }
                case '\\': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = ch;
                    continue block13;
                }
                case '\r': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 114;
                    continue block13;
                }
                case '\n': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 110;
                    continue block13;
                }
                case '\b': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 98;
                    continue block13;
                }
                case '\f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 102;
                    continue block13;
                }
                case '\t': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 116;
                    continue block13;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(48 + ch);
                    continue block13;
                }
                case '\u000b': 
                case '\u000e': 
                case '\u000f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = (char)(97 + (ch - 10));
                    continue block13;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(48 + (ch - 16));
                    continue block13;
                }
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.chars[this.off++] = 92;
                    this.chars[this.off++] = 117;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 48;
                    this.chars[this.off++] = 49;
                    this.chars[this.off++] = (char)(97 + (ch - 26));
                    continue block13;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        this.chars[this.off++] = 92;
                        this.chars[this.off++] = 117;
                        this.chars[this.off++] = DIGITS[ch >>> 12 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 8 & 0xF];
                        this.chars[this.off++] = DIGITS[ch >>> 4 & 0xF];
                        this.chars[this.off++] = DIGITS[ch & 0xF];
                        continue block13;
                    }
                    this.chars[this.off++] = ch;
                }
            }
        }
        if (quote) {
            this.chars[this.off++] = this.quote;
        }
    }

    @Override
    public final void writeReference(String path) {
        this.lastReference = path;
        this.writeRaw(REF_PREF, 0, REF_PREF.length);
        this.writeString(path);
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 125;
    }

    @Override
    public final void writeBase64(byte[] bytes) {
        int i;
        if (bytes == null) {
            this.writeArrayNull();
            return;
        }
        int charsLen = (bytes.length - 1) / 3 + 1 << 2;
        this.ensureCapacity(this.off + charsLen + 2);
        this.chars[this.off++] = this.quote;
        int eLen = bytes.length / 3 * 3;
        int s = 0;
        while (s < eLen) {
            i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.chars[this.off++] = JSONFactory.CA[i >>> 18 & 0x3F];
            this.chars[this.off++] = JSONFactory.CA[i >>> 12 & 0x3F];
            this.chars[this.off++] = JSONFactory.CA[i >>> 6 & 0x3F];
            this.chars[this.off++] = JSONFactory.CA[i & 0x3F];
        }
        int left = bytes.length - eLen;
        if (left > 0) {
            i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytes.length - 1] & 0xFF) << 2 : 0);
            this.chars[this.off++] = JSONFactory.CA[i >> 12];
            this.chars[this.off++] = JSONFactory.CA[i >>> 6 & 0x3F];
            this.chars[this.off++] = left == 2 ? JSONFactory.CA[i & 0x3F] : 61;
            this.chars[this.off++] = 61;
        }
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeHex(byte[] bytes) {
        if (bytes == null) {
            this.writeNull();
            return;
        }
        int charsLen = bytes.length * 2 + 3;
        this.ensureCapacity(this.off + charsLen + 2);
        this.chars[this.off++] = 120;
        this.chars[this.off++] = 39;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int a = b & 0xFF;
            int b0 = a >> 4;
            int b1 = a & 0xF;
            this.chars[this.off++] = (char)(b0 + (b0 < 10 ? 48 : 55));
            this.chars[this.off++] = (char)(b1 + (b1 < 10 ? 48 : 55));
        }
        this.chars[this.off++] = 39;
    }

    @Override
    public final void writeBigInt(BigInteger value, long features) {
        boolean browserCompatible;
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        String str = value.toString(10);
        boolean bl = browserCompatible = ((this.context.features | features) & JSONWriter.Feature.BrowserCompatible.mask) != 0L;
        if (browserCompatible && (value.compareTo(JSONFactory.LOW_BIGINT) < 0 || value.compareTo(JSONFactory.HIGH_BIGINT) > 0)) {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen + 2);
            this.chars[this.off++] = 34;
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
            this.chars[this.off++] = 34;
        } else {
            int strlen = str.length();
            this.ensureCapacity(this.off + strlen);
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
        }
    }

    @Override
    public final void writeDecimal(BigDecimal value, long features, DecimalFormat format) {
        if (value == null) {
            this.writeNumberNull();
            return;
        }
        if (format != null) {
            String str = format.format(value);
            this.writeRaw(str);
            return;
        }
        int precision = value.precision();
        boolean browserCompatible = ((features |= this.context.features) & JSONWriter.Feature.BrowserCompatible.mask) != 0L && precision >= 16 && (value.compareTo(JSONFactory.LOW) < 0 || value.compareTo(JSONFactory.HIGH) > 0);
        int minCapacity = this.off + precision + 4;
        if (minCapacity > this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        if (browserCompatible) {
            this.chars[this.off++] = 34;
        }
        if ((features & JSONWriter.Feature.WriteBigDecimalAsPlain.mask) != 0L) {
            long unscaleValue;
            if (precision < 19 && JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET != -1L && (unscaleValue = UnsafeUtils.getLong(value, JDKUtils.FIELD_DECIMAL_INT_COMPACT_OFFSET)) != Long.MIN_VALUE) {
                int scale = value.scale();
                this.off += IOUtils.getDecimalChars(unscaleValue, scale, this.chars, this.off);
            } else {
                String str = value.toPlainString();
                str.getChars(0, str.length(), this.chars, this.off);
                this.off += str.length();
            }
        } else {
            String str = value.toString();
            int strlen = str.length();
            str.getChars(0, strlen, this.chars, this.off);
            this.off += strlen;
        }
        if (browserCompatible) {
            this.chars[this.off++] = 34;
        }
    }

    @Override
    public final void writeUUID(UUID value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        int minCapacity = this.off + 38;
        if (minCapacity > this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = 34;
        JSONWriterUTF16.formatUnsignedLong0(lsb, this.chars, this.off + 24, 12);
        JSONWriterUTF16.formatUnsignedLong0(lsb >>> 48, this.chars, this.off + 19, 4);
        JSONWriterUTF16.formatUnsignedLong0(msb, this.chars, this.off + 14, 4);
        JSONWriterUTF16.formatUnsignedLong0(msb >>> 16, this.chars, this.off + 9, 4);
        JSONWriterUTF16.formatUnsignedLong0(msb >>> 32, this.chars, this.off + 0, 8);
        this.chars[this.off + 23] = 45;
        this.chars[this.off + 18] = 45;
        this.chars[this.off + 13] = 45;
        this.chars[this.off + 8] = 45;
        this.off += 36;
        this.chars[this.off++] = 34;
    }

    @Override
    public final void writeRaw(String str) {
        this.ensureCapacity(this.off + str.length());
        str.getChars(0, str.length(), this.chars, this.off);
        this.off += str.length();
    }

    @Override
    public final void writeRaw(char[] chars, int off, int charslen) {
        int minCapacity = this.off + charslen;
        if (minCapacity - this.chars.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        System.arraycopy(chars, off, this.chars, this.off, charslen);
        this.off += charslen;
    }

    @Override
    public final void writeChar(char ch) {
        int minCapacity = this.off + 8;
        if (minCapacity - this.chars.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = this.quote;
        switch (ch) {
            case '\"': 
            case '\'': {
                if (ch == this.quote) {
                    this.chars[this.off++] = 92;
                }
                this.chars[this.off++] = ch;
                break;
            }
            case '\\': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = ch;
                break;
            }
            case '\r': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 114;
                break;
            }
            case '\n': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 110;
                break;
            }
            case '\b': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 98;
                break;
            }
            case '\f': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 102;
                break;
            }
            case '\t': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 116;
                break;
            }
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 117;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = (char)(48 + ch);
                break;
            }
            case '\u000b': 
            case '\u000e': 
            case '\u000f': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 117;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = (char)(97 + (ch - 10));
                break;
            }
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 117;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = 49;
                this.chars[this.off++] = (char)(48 + (ch - 16));
                break;
            }
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                this.chars[this.off++] = 92;
                this.chars[this.off++] = 117;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = 48;
                this.chars[this.off++] = 49;
                this.chars[this.off++] = (char)(97 + (ch - 26));
                break;
            }
            default: {
                this.chars[this.off++] = ch;
            }
        }
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeRaw(char ch) {
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = ch;
    }

    @Override
    public final void writeRaw(char c0, char c1) {
        if (this.off + 1 >= this.chars.length) {
            this.ensureCapacity(this.off + 2);
        }
        this.chars[this.off++] = c0;
        this.chars[this.off++] = c1;
    }

    @Override
    public final void writeNameRaw(char[] chars) {
        int minCapacity = this.off + chars.length + (this.startObject ? 0 : 1);
        if (minCapacity - this.chars.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.chars[this.off++] = 44;
        }
        System.arraycopy(chars, 0, this.chars, this.off, chars.length);
        this.off += chars.length;
    }

    @Override
    public final void writeNameRaw(char[] chars, int off, int len) {
        int minCapacity = this.off + len + (this.startObject ? 0 : 1);
        if (minCapacity - this.chars.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.chars[this.off++] = 44;
        }
        System.arraycopy(chars, off, this.chars, this.off, len);
        this.off += len;
    }

    final void ensureCapacity(int minCapacity) {
        if (minCapacity - this.chars.length > 0) {
            int oldCapacity = this.chars.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - this.maxArraySize > 0) {
                throw new OutOfMemoryError();
            }
            this.chars = Arrays.copyOf(this.chars, newCapacity);
        }
    }

    @Override
    public final void writeInt32(int[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 91;
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                if (this.off == this.chars.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.chars[this.off++] = 44;
            }
            this.writeInt32(value[i]);
        }
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeInt32(int i) {
        boolean writeAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 13;
        if (minCapacity >= this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        if (writeAsString) {
            this.chars[this.off++] = 34;
            this.off = IOUtils.writeInt32(this.chars, this.off, i);
            this.chars[this.off++] = 34;
        } else {
            this.off = IOUtils.writeInt32(this.chars, this.off, i);
        }
    }

    @Override
    public final void writeInt64(long[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        boolean browserCompatible = (this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L;
        boolean noneStringAsString = (this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) != 0L;
        boolean writeAsString = noneStringAsString || browserCompatible;
        int minCapacity = this.off + 2 + values.length * (writeAsString ? 23 : 21);
        if (minCapacity >= this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = 91;
        if (writeAsString) {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    this.chars[this.off++] = 44;
                }
                long v = values[i];
                if (!noneStringAsString && browserCompatible && v <= 0x1FFFFFFFFFFFFFL && v >= -9007199254740991L) {
                    this.off = IOUtils.writeInt64(this.chars, this.off, v);
                    continue;
                }
                this.chars[this.off++] = 34;
                this.off = IOUtils.writeInt64(this.chars, this.off, v);
                this.chars[this.off++] = 34;
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    this.chars[this.off++] = 44;
                }
                long v = values[i];
                this.off = IOUtils.writeInt64(this.chars, this.off, v);
            }
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeInt64(long i) {
        boolean writeAsString = (this.context.features & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) != 0L || (this.context.features & JSONWriter.Feature.BrowserCompatible.mask) != 0L && (i > 0x1FFFFFFFFFFFFFL || i < -9007199254740991L);
        int minCapacity = this.off + 23;
        if (minCapacity >= this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        if (writeAsString) {
            this.chars[this.off++] = 34;
            this.off = IOUtils.writeInt64(this.chars, this.off, i);
            this.chars[this.off++] = 34;
        } else {
            this.off = IOUtils.writeInt64(this.chars, this.off, i);
        }
    }

    @Override
    public final void writeFloat(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            this.writeNull();
            return;
        }
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 15;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        this.ensureCapacity(minCapacity);
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        int len = RyuDouble.toString(value, this.chars, this.off);
        this.off += len;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
    }

    @Override
    public final void writeFloat(float[] values) {
        if (values == null) {
            this.writeArrayNull();
            return;
        }
        int minCapacity = this.off + values.length * 16 + 1;
        if (minCapacity - this.chars.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            float value;
            if (i != 0) {
                this.chars[this.off++] = 44;
            }
            if (Float.isNaN(value = values[i]) || Float.isInfinite(value)) {
                this.chars[this.off] = 110;
                this.chars[this.off + 1] = 117;
                this.chars[this.off + 2] = 108;
                this.chars[this.off + 3] = 108;
                this.off += 4;
                continue;
            }
            int len = RyuDouble.toString(value, this.chars, this.off);
            this.off += len;
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeDouble(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.writeNull();
            return;
        }
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 24;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        if (minCapacity > this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        int len = RyuDouble.toString(value, this.chars, this.off);
        this.off += len;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
    }

    @Override
    public final void writeDoubleArray(double value0, double value1) {
        boolean writeNonStringValueAsString = (this.context.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        int minCapacity = this.off + 48 + 3;
        if (writeNonStringValueAsString) {
            minCapacity += 2;
        }
        this.ensureCapacity(minCapacity);
        this.chars[this.off++] = 91;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        int len0 = RyuDouble.toString(value0, this.chars, this.off);
        this.off += len0;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        this.chars[this.off++] = 44;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        int len1 = RyuDouble.toString(value1, this.chars, this.off);
        this.off += len1;
        if (writeNonStringValueAsString) {
            this.chars[this.off++] = 34;
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeDouble(double[] values) {
        if (values == null) {
            this.writeNull();
            return;
        }
        int minCapacity = this.off + values.length * 25 + 1;
        if (minCapacity - this.chars.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = 91;
        for (int i = 0; i < values.length; ++i) {
            double value;
            if (i != 0) {
                this.chars[this.off++] = 44;
            }
            if (Double.isNaN(value = values[i]) || Double.isInfinite(value)) {
                this.chars[this.off] = 110;
                this.chars[this.off + 1] = 117;
                this.chars[this.off + 2] = 108;
                this.chars[this.off + 3] = 108;
                this.off += 4;
                continue;
            }
            int len = RyuDouble.toString(value, this.chars, this.off);
            this.off += len;
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeDateTime14(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 16);
        this.chars[this.off++] = this.quote;
        IOUtils.write4(year, this.chars, this.off);
        this.off += 4;
        IOUtils.write2(month, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = (char)(dayOfMonth / 10 + 48);
        this.chars[this.off++] = (char)(dayOfMonth % 10 + 48);
        this.chars[this.off++] = (char)(hour / 10 + 48);
        this.chars[this.off++] = (char)(hour % 10 + 48);
        this.chars[this.off++] = (char)(minute / 10 + 48);
        this.chars[this.off++] = (char)(minute % 10 + 48);
        this.chars[this.off++] = (char)(second / 10 + 48);
        this.chars[this.off++] = (char)(second % 10 + 48);
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.ensureCapacity(this.off + 21);
        this.chars[this.off++] = this.quote;
        IOUtils.write4(year, this.chars, this.off);
        this.off += 4;
        this.chars[this.off++] = 45;
        IOUtils.write2(month, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 45;
        this.chars[this.off++] = (char)(dayOfMonth / 10 + 48);
        this.chars[this.off++] = (char)(dayOfMonth % 10 + 48);
        this.chars[this.off++] = 32;
        this.chars[this.off++] = (char)(hour / 10 + 48);
        this.chars[this.off++] = (char)(hour % 10 + 48);
        this.chars[this.off++] = 58;
        this.chars[this.off++] = (char)(minute / 10 + 48);
        this.chars[this.off++] = (char)(minute % 10 + 48);
        this.chars[this.off++] = 58;
        this.chars[this.off++] = (char)(second / 10 + 48);
        this.chars[this.off++] = (char)(second % 10 + 48);
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeLocalDate(LocalDate date) {
        int minCapacity;
        if (date == null) {
            this.writeNull();
            return;
        }
        if (this.context.dateFormat != null) {
            if (this.context.dateFormatUnixTime) {
                LocalDateTime dateTime = LocalDateTime.of(date, LocalTime.MIN);
                long millis = dateTime.atZone(this.context.getZoneId()).toInstant().toEpochMilli();
                this.writeInt64(millis / 1000L);
                return;
            }
            if (this.context.dateFormatMillis) {
                LocalDateTime dateTime = LocalDateTime.of(date, LocalTime.MIN);
                long millis = dateTime.atZone(this.context.getZoneId()).toInstant().toEpochMilli();
                this.writeInt64(millis);
                return;
            }
            DateTimeFormatter formatter = this.context.getDateFormatter();
            if (formatter != null) {
                String str = this.context.isDateFormatHasHour() ? formatter.format(LocalDateTime.of(date, LocalTime.MIN)) : formatter.format(date);
                this.writeString(str);
                return;
            }
        }
        if ((minCapacity = this.off + 18) > this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = this.quote;
        this.writeLocalDate0(date);
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeLocalDateTime(LocalDateTime dateTime) {
        int minCapacity = this.off + 38;
        if (minCapacity >= this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = this.quote;
        this.writeLocalDate0(dateTime.toLocalDate());
        this.chars[this.off++] = 32;
        this.writeLocalTime0(dateTime.toLocalTime());
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds, boolean timeZone) {
        int zonelen = timeZone ? (offsetSeconds == 0 ? 1 : 6) : 0;
        int minCapacity = this.off + 25 + zonelen;
        if (this.off + minCapacity >= this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = this.quote;
        IOUtils.write4(year, this.chars, this.off);
        this.off += 4;
        this.chars[this.off++] = 45;
        IOUtils.write2(month, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 45;
        IOUtils.write2(dayOfMonth, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = timeZone ? 84 : 32;
        IOUtils.write2(hour, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 58;
        IOUtils.write2(minute, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 58;
        IOUtils.write2(second, this.chars, this.off);
        this.off += 2;
        if (millis > 0) {
            this.chars[this.off++] = 46;
            int div = millis / 10;
            int div2 = div / 10;
            int rem1 = millis - div * 10;
            if (rem1 != 0) {
                IOUtils.write3(millis, this.chars, this.off);
                this.off += 3;
            } else {
                int rem2 = div - div2 * 10;
                if (rem2 != 0) {
                    IOUtils.write2(div, this.chars, this.off);
                    this.off += 2;
                } else {
                    this.chars[this.off++] = (char)(div2 + 48);
                }
            }
        }
        if (timeZone) {
            int offset = offsetSeconds / 3600;
            if (offsetSeconds == 0) {
                this.chars[this.off++] = 90;
            } else {
                int offsetAbs = Math.abs(offset);
                this.chars[this.off++] = offset >= 0 ? 43 : 45;
                IOUtils.write2(offsetAbs, this.chars, this.off);
                this.off += 2;
                this.chars[this.off++] = 58;
                int offsetMinutes = (offsetSeconds - offset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                IOUtils.write2(offsetMinutes, this.chars, this.off);
                this.off += 2;
            }
        }
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeDateYYYMMDD8(int year, int month, int dayOfMonth) {
        this.ensureCapacity(this.off + 10);
        this.chars[this.off++] = this.quote;
        IOUtils.write4(year, this.chars, this.off);
        this.off += 4;
        IOUtils.write2(month, this.chars, this.off);
        this.off += 2;
        IOUtils.write2(dayOfMonth, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        this.ensureCapacity(this.off + 12);
        this.chars[this.off++] = this.quote;
        IOUtils.write4(year, this.chars, this.off);
        this.off += 4;
        this.chars[this.off++] = 45;
        IOUtils.write2(month, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 45;
        IOUtils.write2(dayOfMonth, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeTimeHHMMSS8(int hour, int minute, int second) {
        this.ensureCapacity(this.off + 10);
        this.chars[this.off++] = this.quote;
        IOUtils.write2(hour, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 58;
        IOUtils.write2(minute, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 58;
        IOUtils.write2(second, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeLocalTime(LocalTime time) {
        int minCapacity = this.off + 20;
        if (minCapacity >= this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = this.quote;
        this.writeLocalTime0(time);
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeZonedDateTime(ZonedDateTime dateTime) {
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        ZoneId zone = dateTime.getZone();
        String zoneId = zone.getId();
        char firstZoneChar = '\u0000';
        if (ZoneOffset.UTC == zone || zoneId.length() <= 3 && ("UTC".equals(zoneId) || "Z".equals(zoneId))) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = zoneId.length() != 0 && ((firstZoneChar = zoneId.charAt(0)) == '+' || firstZoneChar == '-') ? zoneId.length() : 2 + zoneId.length();
        }
        int minCapacity = this.off + zoneSize + 38;
        if (minCapacity > this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = this.quote;
        this.writeLocalDate0(dateTime.toLocalDate());
        this.chars[this.off++] = 84;
        this.writeLocalTime0(dateTime.toLocalTime());
        if (zoneSize == 1) {
            this.chars[this.off++] = 90;
        } else if (firstZoneChar == '+' || firstZoneChar == '-') {
            zoneId.getChars(0, zoneId.length(), this.chars, this.off);
            this.off += zoneId.length();
        } else {
            this.chars[this.off++] = 91;
            zoneId.getChars(0, zoneId.length(), this.chars, this.off);
            this.off += zoneId.length();
            this.chars[this.off++] = 93;
        }
        this.chars[this.off++] = this.quote;
    }

    @Override
    public final void writeOffsetDateTime(OffsetDateTime dateTime) {
        int zoneSize;
        if (dateTime == null) {
            this.writeNull();
            return;
        }
        ZoneOffset offset = dateTime.getOffset();
        String zoneId = offset.getId();
        char firstZoneChar = '\u0000';
        if (ZoneOffset.UTC == offset || zoneId.length() <= 3 && ("UTC".equals(zoneId) || "Z".equals(zoneId))) {
            zoneId = "Z";
            zoneSize = 1;
        } else {
            zoneSize = zoneId.length() != 0 && ((firstZoneChar = zoneId.charAt(0)) == '+' || firstZoneChar == '-') ? zoneId.length() : 2 + zoneId.length();
        }
        int minCapacity = this.off + zoneSize + 38;
        if (minCapacity > this.chars.length) {
            this.ensureCapacity(minCapacity);
        }
        this.chars[this.off++] = this.quote;
        this.writeLocalDate0(dateTime.toLocalDate());
        this.chars[this.off++] = 84;
        this.writeLocalTime0(dateTime.toLocalTime());
        if (zoneSize == 1) {
            this.chars[this.off++] = 90;
        } else if (firstZoneChar == '+' || firstZoneChar == '-') {
            zoneId.getChars(0, zoneId.length(), this.chars, this.off);
            this.off += zoneId.length();
        } else {
            this.chars[this.off++] = 91;
            zoneId.getChars(0, zoneId.length(), this.chars, this.off);
            this.off += zoneId.length();
            this.chars[this.off++] = 93;
        }
        this.chars[this.off++] = this.quote;
    }

    final void writeLocalDate0(LocalDate localDate) {
        int year = localDate.getYear();
        if (year >= 0 && year < 10000) {
            IOUtils.write4(year, this.chars, this.off);
            this.off += 4;
        } else {
            int yearSize = year > 0 ? IOUtils.stringSize(year) : IOUtils.stringSize(-year) + 1;
            IOUtils.getChars(year, this.off + yearSize, this.chars);
            this.off += yearSize;
        }
        this.chars[this.off++] = 45;
        int month = localDate.getMonthValue();
        IOUtils.write2(month, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 45;
        int dayOfMonth = localDate.getDayOfMonth();
        IOUtils.write2(dayOfMonth, this.chars, this.off);
        this.off += 2;
    }

    final void writeLocalTime0(LocalTime time) {
        int hour = time.getHour();
        IOUtils.write2(hour, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 58;
        int minute = time.getMinute();
        IOUtils.write2(minute, this.chars, this.off);
        this.off += 2;
        this.chars[this.off++] = 58;
        int second = time.getSecond();
        IOUtils.write2(second, this.chars, this.off);
        this.off += 2;
        int nano = time.getNano();
        if (nano != 0) {
            int div = nano / 1000;
            int div2 = div / 1000;
            int rem1 = nano - div * 1000;
            this.chars[this.off++] = 46;
            if (rem1 != 0) {
                IOUtils.write3(div2, this.chars, this.off);
                IOUtils.write3(div - div2 * 1000, this.chars, this.off + 3);
                IOUtils.write3(rem1, this.chars, this.off + 6);
                this.off += 9;
            } else {
                int rem2 = div - div2 * 1000;
                if (rem2 != 0) {
                    IOUtils.write3(div2, this.chars, this.off);
                    IOUtils.write3(rem2, this.chars, this.off + 3);
                    this.off += 6;
                } else {
                    IOUtils.write3(div2, this.chars, this.off);
                    this.off += 3;
                }
            }
        }
    }

    @Override
    public final void writeNameRaw(byte[] bytes) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final int flushTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new JSONException("out is nulll");
        }
        boolean ascii = true;
        for (int i = 0; i < this.off; ++i) {
            if (this.chars[i] < '\u0080') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            byte[] bytes = new byte[this.off];
            for (int i = 0; i < this.off; ++i) {
                bytes[i] = (byte)this.chars[i];
            }
            out.write(bytes);
            this.off = 0;
            return bytes.length;
        }
        byte[] utf8 = new byte[this.off * 3];
        int utf8Length = IOUtils.encodeUTF8(this.chars, 0, this.off, utf8, 0);
        out.write(utf8, 0, utf8Length);
        this.off = 0;
        return utf8Length;
    }

    @Override
    public final int flushTo(OutputStream out, Charset charset) throws IOException {
        if (this.off == 0) {
            return 0;
        }
        if (out == null) {
            throw new JSONException("out is null");
        }
        byte[] bytes = this.getBytes(charset);
        out.write(bytes);
        this.off = 0;
        return bytes.length;
    }

    public final String toString() {
        return new String(this.chars, 0, this.off);
    }

    static void formatUnsignedLong0(long val, char[] buf, int offset, int len) {
        int charPos = offset + len;
        do {
            buf[--charPos] = DIGITS[(int)val & 0xF];
            val >>>= 4;
        } while (charPos > offset);
    }

    @Override
    public final byte[] getBytes() {
        boolean ascii = true;
        for (int i = 0; i < this.off; ++i) {
            if (this.chars[i] < '\u0080') continue;
            ascii = false;
            break;
        }
        if (ascii) {
            byte[] bytes = new byte[this.off];
            for (int i = 0; i < this.off; ++i) {
                bytes[i] = (byte)this.chars[i];
            }
            return bytes;
        }
        byte[] utf8 = new byte[this.off * 3];
        int utf8Length = IOUtils.encodeUTF8(this.chars, 0, this.off, utf8, 0);
        return Arrays.copyOf(utf8, utf8Length);
    }

    @Override
    public final int size() {
        return this.off;
    }

    @Override
    public final byte[] getBytes(Charset charset) {
        boolean ascii = true;
        for (int i = 0; i < this.off; ++i) {
            if (this.chars[i] < '\u0080') continue;
            ascii = false;
            break;
        }
        if (ascii && (charset == StandardCharsets.UTF_8 || charset == StandardCharsets.ISO_8859_1 || charset == StandardCharsets.US_ASCII)) {
            byte[] bytes = new byte[this.off];
            for (int i = 0; i < this.off; ++i) {
                bytes[i] = (byte)this.chars[i];
            }
            return bytes;
        }
        String str = new String(this.chars, 0, this.off);
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return str.getBytes(charset);
    }

    @Override
    public final void writeRaw(byte[] bytes) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final void write(JSONObject map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        long NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(map.getClass());
            objectWriter.write(this, map, null, null, 0L);
            return;
        }
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 123;
        boolean first = true;
        for (Map.Entry next : map.entrySet()) {
            Object value = next.getValue();
            if (value == null && (this.context.features & JSONWriter.Feature.WriteMapNullValue.mask) == 0L) continue;
            if (!first) {
                if (this.off == this.chars.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.chars[this.off++] = 44;
            }
            first = false;
            this.writeString((String)next.getKey());
            if (this.off == this.chars.length) {
                this.ensureCapacity(this.off + 1);
            }
            this.chars[this.off++] = 58;
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 125;
    }

    @Override
    public final void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        long NONE_DIRECT_FEATURES = JSONWriter.Feature.ReferenceDetection.mask | JSONWriter.Feature.PrettyFormat.mask | JSONWriter.Feature.NotWriteEmptyArray.mask | JSONWriter.Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(array.getClass());
            objectWriter.write(this, array, null, null, 0L);
            return;
        }
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 91;
        boolean first = true;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            if (!first) {
                if (this.off == this.chars.length) {
                    this.ensureCapacity(this.off + 1);
                }
                this.chars[this.off++] = 44;
            }
            first = false;
            Object value = array.get(i);
            if (value == null) {
                this.writeNull();
                continue;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                this.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                this.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                this.writeInt64((Long)value);
                continue;
            }
            if (valueClass == Boolean.class) {
                this.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                this.writeDecimal((BigDecimal)value, 0L, null);
                continue;
            }
            if (valueClass == JSONArray.class) {
                this.write((JSONArray)value);
                continue;
            }
            if (valueClass == JSONObject.class) {
                this.write((JSONObject)value);
                continue;
            }
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
            objectWriter.write(this, value, null, null, 0L);
        }
        if (this.off == this.chars.length) {
            this.ensureCapacity(this.off + 1);
        }
        this.chars[this.off++] = 93;
    }

    @Override
    public final void writeString(char[] chars) {
        if (chars == null) {
            this.writeStringNull();
            return;
        }
        boolean browserSecure = (this.context.features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        boolean special = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\\' || c == this.quote || c < ' ') {
                special = true;
                break;
            }
            if (!browserSecure || c != '<' && c != '>' && c != '(' && c != ')') continue;
            special = true;
            break;
        }
        if (!special) {
            int minCapacity = this.off + chars.length + 2;
            if (minCapacity - this.chars.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.chars[this.off++] = this.quote;
            System.arraycopy(chars, 0, this.chars, this.off, chars.length);
            this.off += chars.length;
            this.chars[this.off++] = this.quote;
            return;
        }
        this.writeStringEscape(chars);
    }

    @Override
    public final void writeString(char[] chars, int off, int len) {
        if (chars == null) {
            this.writeStringNull();
            return;
        }
        boolean special = false;
        for (int i = off; i < len; ++i) {
            if (chars[i] != '\\' && chars[i] != '\"') continue;
            special = true;
            break;
        }
        if (!special) {
            int minCapacity = this.off + len + 2;
            if (minCapacity - this.chars.length > 0) {
                this.ensureCapacity(minCapacity);
            }
            this.chars[this.off++] = this.quote;
            System.arraycopy(chars, off, this.chars, this.off, len);
            this.off += len;
            this.chars[this.off++] = this.quote;
            return;
        }
        this.writeStringEscape(new String(chars, off, len));
    }
}

