/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.controller;

import com.likeusewin10.dto.request.ArticleRequest;
import com.likeusewin10.dto.response.ArticleResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.ArticleService;
import com.likeusewin10.util.JwtUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/article"})
public class ArticleController {
    @Autowired
    private ArticleService articleService;

    @GetMapping(value={"/list"})
    public Result<PageResult<ArticleResponse>> getArticleList(@RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size) {
        return this.articleService.getArticleList(Integer.valueOf(current), Integer.valueOf(size));
    }

    @GetMapping(value={"/my-articles"})
    public Result<PageResult<ArticleResponse>> getUserArticles(HttpServletRequest request, @RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            return this.articleService.getUserArticles(userId, Integer.valueOf(current), Integer.valueOf(size));
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u7528\u6237\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/{id}"})
    public Result<ArticleResponse> getArticleById(@PathVariable Long id) {
        return this.articleService.getArticleById(id);
    }

    @PostMapping
    public Result<Void> createArticle(HttpServletRequest request, @RequestBody ArticleRequest articleRequest) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            articleRequest.setAuthorId(userId);
            return this.articleService.createArticle(userId, articleRequest);
        }
        catch (Exception e) {
            return Result.error((String)("\u521b\u5efa\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PutMapping(value={"/{id}"})
    public Result<Void> updateArticle(HttpServletRequest request, @PathVariable Long id, @RequestBody ArticleRequest articleRequest) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            return this.articleService.updateArticle(userId, id, articleRequest);
        }
        catch (Exception e) {
            return Result.error((String)("\u66f4\u65b0\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/{id}"})
    public Result<Void> deleteArticle(HttpServletRequest request, @PathVariable Long id) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            return this.articleService.deleteArticle(userId, id);
        }
        catch (Exception e) {
            return Result.error((String)("\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/search"})
    public Result<PageResult<ArticleResponse>> searchArticles(@RequestParam String keyword, @RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size) {
        return this.articleService.searchArticles(keyword, Integer.valueOf(current), Integer.valueOf(size));
    }
}

