/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.controller;

import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.CaptchaService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class CaptchaController {
    @Autowired
    private CaptchaService captchaService;

    @GetMapping(value={"/captcha"})
    public Result<Map<String, Object>> generateCaptcha(HttpServletRequest request) {
        try {
            Map captchaData = this.captchaService.generateCaptcha(request);
            return Result.success((Object)captchaData);
        }
        catch (Exception e) {
            return Result.error((String)("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/captcha/verify"})
    public Result<Boolean> verifyCaptcha(@RequestBody Map<String, String> request, HttpServletRequest httpRequest) {
        try {
            String captchaId = request.get("captchaId");
            String captcha = request.get("captcha");
            boolean isValid = this.captchaService.verifyCaptcha(captchaId, captcha, httpRequest);
            return Result.success((Object)isValid);
        }
        catch (Exception e) {
            return Result.error((String)("\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

