/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.controller;

import com.likeusewin10.dto.request.CommentRequest;
import com.likeusewin10.dto.response.CommentResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.CommentService;
import com.likeusewin10.util.JwtUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/comment"})
public class CommentController {
    @Autowired
    private CommentService commentService;

    @GetMapping(value={"/article/{articleId}"})
    public Result<PageResult<CommentResponse>> getCommentsByArticleId(@PathVariable Long articleId, @RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size) {
        return this.commentService.getCommentsByArticleId(articleId, Integer.valueOf(current), Integer.valueOf(size));
    }

    @PostMapping
    public Result<Void> createComment(HttpServletRequest request, @RequestBody CommentRequest commentRequest) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            commentRequest.setUserId(userId);
            return this.commentService.createComment(userId, commentRequest);
        }
        catch (Exception e) {
            return Result.error((String)("\u521b\u5efa\u8bc4\u8bba\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/{id}"})
    public Result<Void> deleteComment(HttpServletRequest request, @PathVariable Long id) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            return this.commentService.deleteComment(id, userId);
        }
        catch (Exception e) {
            return Result.error((String)("\u5220\u9664\u8bc4\u8bba\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

