/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.controller;

import com.likeusewin10.dto.response.Result;
import com.likeusewin10.entity.User;
import com.likeusewin10.mapper.UserMapper;
import com.likeusewin10.util.JwtUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/upload"})
public class FileUploadController {
    @Autowired
    private UserMapper userMapper;
    private static final String UPLOAD_ROOT = System.getProperty("user.dir") + File.separator + "uploads";
    private static final String[] ALLOWED_IMAGE_TYPES = new String[]{"image/jpeg", "image/jpg", "image/png", "image/gif", "image/webp"};
    private static final long MAX_FILE_SIZE = 0x500000L;

    @PostMapping(value={"/avatar"})
    public Result<Map<String, Object>> uploadAvatar(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            String validationResult = this.validateImageFile(file);
            if (validationResult != null) {
                return Result.error((String)validationResult);
            }
            String fileName = this.generateFileName(file.getOriginalFilename(), "avatar", userId);
            String relativePath = "avatars/" + fileName;
            String fullPath = UPLOAD_ROOT + "/" + relativePath;
            this.saveFile(file, fullPath);
            String avatarUrl = "/uploads/" + relativePath;
            User user = (User)this.userMapper.selectById((Serializable)userId);
            if (user != null) {
                user.setAvatarUrl(avatarUrl);
                user.setUpdatedAt(LocalDateTime.now());
                this.userMapper.updateById((Object)user);
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("url", avatarUrl);
            response.put("fileName", fileName);
            response.put("fileSize", file.getSize());
            return Result.success((String)"\u5934\u50cf\u4e0a\u4f20\u6210\u529f", response);
        }
        catch (Exception e) {
            return Result.error((String)("\u5934\u50cf\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/article-image"})
    public Result<Map<String, Object>> uploadArticleImage(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            String validationResult = this.validateImageFile(file);
            if (validationResult != null) {
                return Result.error((String)validationResult);
            }
            String fileName = this.generateFileName(file.getOriginalFilename(), "article", userId);
            String relativePath = "articles/" + fileName;
            String fullPath = UPLOAD_ROOT + "/" + relativePath;
            this.saveFile(file, fullPath);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("url", "/uploads/" + relativePath);
            response.put("fileName", fileName);
            response.put("fileSize", file.getSize());
            return Result.success((String)"\u6587\u7ae0\u56fe\u7247\u4e0a\u4f20\u6210\u529f", response);
        }
        catch (Exception e) {
            return Result.error((String)("\u6587\u7ae0\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/comment-image"})
    public Result<Map<String, Object>> uploadCommentImage(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            String validationResult = this.validateImageFile(file);
            if (validationResult != null) {
                return Result.error((String)validationResult);
            }
            String fileName = this.generateFileName(file.getOriginalFilename(), "comment", userId);
            String relativePath = "comments/" + fileName;
            String fullPath = UPLOAD_ROOT + "/" + relativePath;
            this.saveFile(file, fullPath);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("url", "/uploads/" + relativePath);
            response.put("fileName", fileName);
            response.put("fileSize", file.getSize());
            return Result.success((String)"\u8bc4\u8bba\u56fe\u7247\u4e0a\u4f20\u6210\u529f", response);
        }
        catch (Exception e) {
            return Result.error((String)("\u8bc4\u8bba\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private String validateImageFile(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return "\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6";
        }
        if (file.getSize() > 0x500000L) {
            return "\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc75MB";
        }
        String contentType = file.getContentType();
        boolean isValidType = false;
        for (String allowedType : ALLOWED_IMAGE_TYPES) {
            if (!allowedType.equals(contentType)) continue;
            isValidType = true;
            break;
        }
        if (!isValidType) {
            return "\u53ea\u652f\u6301JPG\u3001PNG\u3001GIF\u3001WEBP\u683c\u5f0f\u7684\u56fe\u7247";
        }
        return null;
    }

    private String generateFileName(String originalFilename, String type, Long userId) {
        String extension = "";
        if (originalFilename != null && originalFilename.contains(".")) {
            extension = originalFilename.substring(originalFilename.lastIndexOf("."));
        }
        if ("avatar".equals(type)) {
            return String.format("user_%d%s", userId, extension);
        }
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        String uuid = UUID.randomUUID().toString().substring(0, 8);
        return String.format("%s_%d_%s_%s%s", type, userId, timestamp, uuid, extension);
    }

    private void saveFile(MultipartFile file, String fullPath) throws IOException {
        Path path = Paths.get(fullPath, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        file.transferTo(path.toFile());
    }
}

