/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.controller;

import com.likeusewin10.dto.response.GameCategoryResponse;
import com.likeusewin10.dto.response.GameVideoResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.GameService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/game"})
public class GameController {
    @Autowired
    private GameService gameService;

    @GetMapping(value={"/categories"})
    public Result<List<GameCategoryResponse>> getGameCategories() {
        return this.gameService.getGameCategories();
    }

    @GetMapping(value={"/videos"})
    public Result<PageResult<GameVideoResponse>> getGameVideos(@RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size, @RequestParam(required=false) String category) {
        return this.gameService.getGameVideos(category, Integer.valueOf(current), Integer.valueOf(size));
    }

    @GetMapping(value={"/videos/{id}"})
    public Result<GameVideoResponse> getGameVideoById(@PathVariable Long id) {
        return this.gameService.getGameById(id);
    }

    @GetMapping(value={"/search"})
    public Result<PageResult<GameVideoResponse>> searchGameVideos(@RequestParam String keyword, @RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size) {
        return this.gameService.searchGameVideos(keyword, Integer.valueOf(current), Integer.valueOf(size));
    }
}

