/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.controller;

import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.LikeService;
import com.likeusewin10.util.IpUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/like"})
public class LikeController {
    @Autowired
    private LikeService likeService;

    @PostMapping(value={"/toggle/{commentId}"})
    public Result<Map<String, Object>> toggleLike(@PathVariable Long commentId, HttpServletRequest request) {
        String ipAddress = IpUtil.getClientIpAddress((HttpServletRequest)request);
        String message = this.likeService.toggleLike(commentId, ipAddress);
        Integer likeCount = this.likeService.getLikeCount(commentId);
        boolean hasLiked = this.likeService.hasLiked(commentId, ipAddress);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("message", message);
        response.put("likeCount", likeCount);
        response.put("hasLiked", hasLiked);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f", response);
    }

    @GetMapping(value={"/count/{commentId}"})
    public Result<Map<String, Object>> getLikeCount(@PathVariable Long commentId) {
        Integer likeCount = this.likeService.getLikeCount(commentId);
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        response.put("likeCount", likeCount);
        return Result.success((String)"\u83b7\u53d6\u6210\u529f", response);
    }

    @GetMapping(value={"/check/{commentId}"})
    public Result<Map<String, Object>> checkLikeStatus(@PathVariable Long commentId, HttpServletRequest request) {
        String ipAddress = IpUtil.getClientIpAddress((HttpServletRequest)request);
        boolean hasLiked = this.likeService.hasLiked(commentId, ipAddress);
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("hasLiked", hasLiked);
        return Result.success((String)"\u83b7\u53d6\u6210\u529f", response);
    }
}

