/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.controller;

import com.likeusewin10.dto.response.MusicResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.MusicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/music"})
public class MusicController {
    @Autowired
    private MusicService musicService;

    @GetMapping(value={"/list"})
    public Result<PageResult<MusicResponse>> getMusicList(@RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size, @RequestParam(required=false) String genre) {
        return this.musicService.getMusicList(Integer.valueOf(current), Integer.valueOf(size));
    }

    @GetMapping(value={"/{id}"})
    public Result<MusicResponse> getMusicById(@PathVariable Long id) {
        return this.musicService.getMusicById(id);
    }

    @GetMapping(value={"/search"})
    public Result<PageResult<MusicResponse>> searchMusic(@RequestParam String keyword, @RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size) {
        return this.musicService.searchMusic(keyword, Integer.valueOf(current), Integer.valueOf(size));
    }

    @GetMapping(value={"/hot"})
    public Result<PageResult<MusicResponse>> getHotMusic(@RequestParam(defaultValue="1") int current, @RequestParam(defaultValue="10") int size) {
        return this.musicService.getMusicList(Integer.valueOf(current), Integer.valueOf(size));
    }
}

