/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.controller;

import com.likeusewin10.dto.request.ForgotPasswordRequest;
import com.likeusewin10.dto.request.LoginRequest;
import com.likeusewin10.dto.request.RegisterRequest;
import com.likeusewin10.dto.request.ResetPasswordRequest;
import com.likeusewin10.dto.request.UpdatePasswordRequest;
import com.likeusewin10.dto.request.VerifyCodeRequest;
import com.likeusewin10.dto.response.LoginResponse;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.dto.response.UserResponse;
import com.likeusewin10.service.CaptchaService;
import com.likeusewin10.service.UserService;
import com.likeusewin10.util.JwtUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/user"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    private CaptchaService captchaService;

    @PostMapping(value={"/login"})
    public Result<LoginResponse> login(@RequestBody LoginRequest request, HttpServletRequest httpRequest) {
        return this.userService.login(request, httpRequest);
    }

    @PostMapping(value={"/register"})
    public Result<Void> register(@RequestBody RegisterRequest request, HttpServletRequest httpRequest) {
        return this.userService.register(request, httpRequest);
    }

    @PostMapping(value={"/forgot-password"})
    public Result<Void> forgotPassword(@RequestBody ForgotPasswordRequest request) {
        return this.userService.sendForgotPasswordCode(request);
    }

    @PostMapping(value={"/verify-code"})
    public Result<Void> verifyCode(@RequestBody VerifyCodeRequest request) {
        return this.userService.verifyEmailCode(request);
    }

    @PostMapping(value={"/reset-password"})
    public Result<Void> resetPassword(@RequestBody ResetPasswordRequest request) {
        return this.userService.resetPassword(request);
    }

    @GetMapping(value={"/info"})
    public Result<UserResponse> getUserInfo(HttpServletRequest request) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            return this.userService.getUserInfo(userId);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/check-username/{username}"})
    public Result<Boolean> checkUsername(@PathVariable String username) {
        return this.userService.checkUsernameExists(username);
    }

    @GetMapping(value={"/check-email/{email}"})
    public Result<Boolean> checkEmail(@PathVariable String email) {
        return this.userService.checkEmailExists(email);
    }

    @PutMapping(value={"/info"})
    public Result<Void> updateUserInfo(HttpServletRequest request, @RequestBody Map<String, Object> requestData) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            String captchaId = (String)requestData.get("captchaId");
            String captcha = (String)requestData.get("captcha");
            if (captchaId == null || captcha == null) {
                return Result.error((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            }
            if (!this.captchaService.verifyCaptcha(captchaId, captcha, request)) {
                return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f");
            }
            UserResponse userInfo = new UserResponse();
            userInfo.setNickname((String)requestData.get("nickname"));
            userInfo.setEmail((String)requestData.get("email"));
            userInfo.setAvatarUrl((String)requestData.get("avatarUrl"));
            userInfo.setGender((String)requestData.get("gender"));
            userInfo.setBirthday((String)requestData.get("birthday"));
            userInfo.setLocation((String)requestData.get("location"));
            userInfo.setBio((String)requestData.get("bio"));
            return this.userService.updateUserInfo(userId, userInfo);
        }
        catch (Exception e) {
            return Result.error((String)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PutMapping(value={"/password"})
    public Result<Void> updatePassword(HttpServletRequest request, @RequestBody UpdatePasswordRequest updatePasswordRequest) {
        try {
            String token = request.getHeader("Authorization");
            if (token == null || !token.startsWith("Bearer ")) {
                return Result.error((String)"\u672a\u63d0\u4f9b\u6709\u6548\u7684\u8ba4\u8bc1\u4ee4\u724c");
            }
            token = token.substring(7);
            Long userId = JwtUtil.getUserIdFromToken((String)token);
            return this.userService.updatePassword(userId, updatePasswordRequest, request);
        }
        catch (Exception e) {
            return Result.error((String)("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

