/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.likeusewin10.entity.Game;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface GameMapper
extends BaseMapper<Game> {
    @Select(value={"SELECT DISTINCT category FROM games WHERE category IS NOT NULL AND category != ''"})
    public List<String> findAllCategories();

    @Select(value={"SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE category = #{category} ORDER BY created_at DESC"})
    public List<Game> findByCategory(String var1);

    @Select(value={"SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE status = 1 ORDER BY created_at DESC LIMIT #{offset}, #{size}"})
    public List<Game> findGamesByPage(@Param(value="offset") int var1, @Param(value="size") int var2);

    @Select(value={"SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE category = #{category} AND status = 1 ORDER BY created_at DESC LIMIT #{offset}, #{size}"})
    public List<Game> findGamesByCategoryAndPage(@Param(value="category") String var1, @Param(value="offset") int var2, @Param(value="size") int var3);

    @Select(value={"SELECT COUNT(*) FROM games WHERE status = 1"})
    public long countGames();

    @Select(value={"SELECT COUNT(*) FROM games WHERE category = #{category} AND status = 1"})
    public long countGamesByCategory(@Param(value="category") String var1);

    @Select(value={"SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE (title LIKE CONCAT('%', #{keyword}, '%') OR category LIKE CONCAT('%', #{keyword}, '%') OR description LIKE CONCAT('%', #{keyword}, '%')) AND status = 1 ORDER BY created_at DESC LIMIT #{offset}, #{size}"})
    public List<Game> searchGamesByPage(@Param(value="keyword") String var1, @Param(value="offset") int var2, @Param(value="size") int var3);

    @Select(value={"SELECT COUNT(*) FROM games WHERE (title LIKE CONCAT('%', #{keyword}, '%') OR category LIKE CONCAT('%', #{keyword}, '%') OR description LIKE CONCAT('%', #{keyword}, '%')) AND status = 1"})
    public long countSearchGames(@Param(value="keyword") String var1);

    @Select(value={"SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE id = #{id}"})
    public Game findGameById(@Param(value="id") Long var1);
}

