/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.likeusewin10.dto.request.ArticleRequest;
import com.likeusewin10.dto.response.ArticleResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.entity.Article;
import com.likeusewin10.entity.User;
import com.likeusewin10.mapper.ArticleMapper;
import com.likeusewin10.mapper.UserMapper;
import com.likeusewin10.service.ArticleService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArticleServiceImpl
implements ArticleService {
    @Autowired
    private ArticleMapper articleMapper;
    @Autowired
    private UserMapper userMapper;

    public Result<PageResult<ArticleResponse>> getArticleList(Integer current, Integer size) {
        try {
            Page page = new Page((long)current.intValue(), (long)size.intValue());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"status", (Object)1);
            queryWrapper.orderByDesc((Object)"created_at");
            Page articlePage = (Page)this.articleMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            List articleResponses = articlePage.getRecords().stream().map(arg_0 -> this.convertToResponse(arg_0)).collect(Collectors.toList());
            PageResult pageResult = new PageResult();
            pageResult.setRecords(articleResponses);
            pageResult.setTotal(Long.valueOf(articlePage.getTotal()));
            pageResult.setCurrent(Long.valueOf(articlePage.getCurrent()));
            pageResult.setSize(Long.valueOf(articlePage.getSize()));
            pageResult.setPages(Long.valueOf(articlePage.getPages()));
            return Result.success((Object)pageResult);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u6587\u7ae0\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<ArticleResponse> getArticleById(Long id) {
        try {
            Article article = (Article)this.articleMapper.selectById((Serializable)id);
            if (article == null) {
                return Result.error((String)"\u6587\u7ae0\u4e0d\u5b58\u5728");
            }
            ArticleResponse response = this.convertToResponse(article);
            return Result.success((Object)response);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u6587\u7ae0\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> createArticle(Long userId, ArticleRequest request) {
        try {
            Article article = new Article();
            BeanUtils.copyProperties((Object)request, (Object)article);
            article.setAuthorId(userId);
            article.setCreatedAt(LocalDateTime.now());
            article.setUpdatedAt(LocalDateTime.now());
            article.setLikeCount(Integer.valueOf(0));
            article.setStatus(Integer.valueOf(1));
            this.articleMapper.insert((Object)article);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u521b\u5efa\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> updateArticle(Long userId, Long articleId, ArticleRequest request) {
        try {
            Article article = (Article)this.articleMapper.selectById((Serializable)articleId);
            if (article == null) {
                return Result.error((String)"\u6587\u7ae0\u4e0d\u5b58\u5728");
            }
            if (!article.getAuthorId().equals(userId)) {
                return Result.error((String)"\u53ea\u80fd\u4fee\u6539\u81ea\u5df1\u7684\u6587\u7ae0");
            }
            BeanUtils.copyProperties((Object)request, (Object)article);
            article.setUpdatedAt(LocalDateTime.now());
            this.articleMapper.updateById((Object)article);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u66f4\u65b0\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> deleteArticle(Long userId, Long articleId) {
        try {
            Article article = (Article)this.articleMapper.selectById((Serializable)articleId);
            if (article == null) {
                return Result.error((String)"\u6587\u7ae0\u4e0d\u5b58\u5728");
            }
            if (!article.getAuthorId().equals(userId)) {
                return Result.error((String)"\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7684\u6587\u7ae0");
            }
            this.articleMapper.deleteById((Serializable)articleId);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<PageResult<ArticleResponse>> searchArticles(String keyword, Integer current, Integer size) {
        try {
            Page page = new Page((long)current.intValue(), (long)size.intValue());
            QueryWrapper queryWrapper = new QueryWrapper();
            if (keyword != null && !keyword.trim().isEmpty()) {
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.like((Object)"title", (Object)keyword)).or()).like((Object)"content", (Object)keyword)).or()).like((Object)"summary", (Object)keyword);
            }
            queryWrapper.eq((Object)"status", (Object)1);
            queryWrapper.orderByDesc((Object)"created_at");
            Page articlePage = (Page)this.articleMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            List articleResponses = articlePage.getRecords().stream().map(arg_0 -> this.convertToResponse(arg_0)).collect(Collectors.toList());
            PageResult pageResult = new PageResult();
            pageResult.setRecords(articleResponses);
            pageResult.setTotal(Long.valueOf(articlePage.getTotal()));
            pageResult.setCurrent(Long.valueOf(articlePage.getCurrent()));
            pageResult.setSize(Long.valueOf(articlePage.getSize()));
            pageResult.setPages(Long.valueOf(articlePage.getPages()));
            return Result.success((Object)pageResult);
        }
        catch (Exception e) {
            return Result.error((String)("\u641c\u7d22\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<PageResult<ArticleResponse>> getUserArticles(Long userId, Integer current, Integer size) {
        try {
            Page page = new Page((long)current.intValue(), (long)size.intValue());
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"author_id", (Object)userId)).orderByDesc((Object)"created_at");
            Page articlePage = (Page)this.articleMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            List articleResponses = articlePage.getRecords().stream().map(arg_0 -> this.convertToResponse(arg_0)).collect(Collectors.toList());
            PageResult pageResult = new PageResult();
            pageResult.setRecords(articleResponses);
            pageResult.setTotal(Long.valueOf(articlePage.getTotal()));
            pageResult.setCurrent(Long.valueOf(articlePage.getCurrent()));
            pageResult.setSize(Long.valueOf(articlePage.getSize()));
            pageResult.setPages(Long.valueOf(articlePage.getPages()));
            return Result.success((Object)pageResult);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u7528\u6237\u6587\u7ae0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private ArticleResponse convertToResponse(Article article) {
        ArticleResponse response = new ArticleResponse();
        BeanUtils.copyProperties((Object)article, (Object)response);
        User author = (User)this.userMapper.selectById((Serializable)article.getAuthorId());
        if (author != null) {
            response.setAuthorName(author.getNickname() != null ? author.getNickname() : author.getUsername());
        }
        return response;
    }
}

