/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.service.impl;

import com.likeusewin10.service.CaptchaService;
import com.likeusewin10.service.impl.CaptchaServiceImpl;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class CaptchaServiceImpl
implements CaptchaService {
    private static final Map<String, CaptchaInfo> captchaStore = new ConcurrentHashMap();
    private static final String CAPTCHA_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int CAPTCHA_LENGTH = 4;
    private static final long CAPTCHA_EXPIRE_TIME = 300000L;

    public Map<String, Object> generateCaptcha(HttpServletRequest request) {
        String captchaText = this.generateCaptchaText();
        String captchaId = UUID.randomUUID().toString();
        String imageBase64 = this.generateCaptchaImage(captchaText);
        CaptchaInfo captchaInfo = new CaptchaInfo(captchaText, System.currentTimeMillis());
        captchaStore.put(captchaId, captchaInfo);
        this.cleanExpiredCaptcha();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", captchaId);
        result.put("image", "data:image/png;base64," + imageBase64);
        return result;
    }

    public boolean verifyCaptcha(String captchaId, String captcha, HttpServletRequest request) {
        if (captchaId == null || captcha == null) {
            return false;
        }
        CaptchaInfo captchaInfo = (CaptchaInfo)captchaStore.get(captchaId);
        if (captchaInfo == null) {
            return false;
        }
        if (System.currentTimeMillis() - captchaInfo.getCreateTime() > 300000L) {
            captchaStore.remove(captchaId);
            return false;
        }
        captchaStore.remove(captchaId);
        return captchaInfo.getText().equalsIgnoreCase(captcha);
    }

    private String generateCaptchaText() {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int index = random.nextInt(CAPTCHA_CHARS.length());
            sb.append(CAPTCHA_CHARS.charAt(index));
        }
        return sb.toString();
    }

    private String generateCaptchaImage(String captchaText) {
        int i;
        int width = 100;
        int height = 40;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        Random random = new Random();
        g2d.setColor(Color.LIGHT_GRAY);
        for (i = 0; i < 5; ++i) {
            int x1 = random.nextInt(width);
            int y1 = random.nextInt(height);
            int x2 = random.nextInt(width);
            int y2 = random.nextInt(height);
            g2d.drawLine(x1, y1, x2, y2);
        }
        g2d.setFont(new Font("Arial", 1, 20));
        for (i = 0; i < captchaText.length(); ++i) {
            g2d.setColor(new Color(random.nextInt(100), random.nextInt(100), random.nextInt(100)));
            int x = 15 + i * 18;
            int y = 25 + random.nextInt(10);
            double angle = (random.nextDouble() - 0.5) * 0.5;
            g2d.rotate(angle, x, y);
            g2d.drawString(String.valueOf(captchaText.charAt(i)), x, y);
            g2d.rotate(-angle, x, y);
        }
        g2d.dispose();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            byte[] imageBytes = baos.toByteArray();
            return Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("\u751f\u6210\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25", e);
        }
    }

    private void cleanExpiredCaptcha() {
        long currentTime = System.currentTimeMillis();
        captchaStore.entrySet().removeIf(entry -> currentTime - ((CaptchaInfo)entry.getValue()).getCreateTime() > 300000L);
    }
}

