/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.likeusewin10.dto.request.CommentRequest;
import com.likeusewin10.dto.response.CommentResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.entity.Comment;
import com.likeusewin10.entity.User;
import com.likeusewin10.mapper.CommentMapper;
import com.likeusewin10.mapper.UserMapper;
import com.likeusewin10.service.CommentService;
import com.likeusewin10.service.LikeService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommentServiceImpl
implements CommentService {
    @Autowired
    private CommentMapper commentMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private LikeService likeService;

    public Result<PageResult<CommentResponse>> getCommentsByArticleId(Long articleId, Integer current, Integer size) {
        try {
            Page page = new Page((long)current.intValue(), (long)size.intValue());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"article_id", (Object)articleId);
            queryWrapper.orderByDesc((Object)"created_at");
            Page commentPage = (Page)this.commentMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            List commentResponses = commentPage.getRecords().stream().map(arg_0 -> this.convertToResponse(arg_0)).collect(Collectors.toList());
            PageResult pageResult = new PageResult();
            pageResult.setRecords(commentResponses);
            pageResult.setTotal(Long.valueOf(commentPage.getTotal()));
            pageResult.setCurrent(Long.valueOf(commentPage.getCurrent()));
            pageResult.setSize(Long.valueOf(commentPage.getSize()));
            pageResult.setPages(Long.valueOf(commentPage.getPages()));
            return Result.success((Object)pageResult);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u8bc4\u8bba\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> createComment(Long userId, CommentRequest request) {
        try {
            Comment comment = new Comment();
            BeanUtils.copyProperties((Object)request, (Object)comment);
            comment.setUserId(userId);
            comment.setCreatedAt(LocalDateTime.now());
            comment.setUpdatedAt(LocalDateTime.now());
            this.commentMapper.insert((Object)comment);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u521b\u5efa\u8bc4\u8bba\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> deleteComment(Long commentId, Long userId) {
        try {
            Comment comment = (Comment)this.commentMapper.selectById((Serializable)commentId);
            if (comment == null) {
                return Result.error((String)"\u8bc4\u8bba\u4e0d\u5b58\u5728");
            }
            if (!comment.getUserId().equals(userId)) {
                return Result.error((String)"\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7684\u8bc4\u8bba");
            }
            this.commentMapper.deleteById((Serializable)commentId);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u5220\u9664\u8bc4\u8bba\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<PageResult<CommentResponse>> getUserComments(Long userId, Integer current, Integer size) {
        try {
            Page page = new Page((long)current.intValue(), (long)size.intValue());
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"user_id", (Object)userId)).orderByDesc((Object)"created_at");
            Page commentPage = (Page)this.commentMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            List responseList = commentPage.getRecords().stream().map(arg_0 -> this.convertToResponse(arg_0)).collect(Collectors.toList());
            PageResult pageResult = new PageResult();
            pageResult.setRecords(responseList);
            pageResult.setTotal(Long.valueOf(commentPage.getTotal()));
            pageResult.setCurrent(Long.valueOf(commentPage.getCurrent()));
            pageResult.setSize(Long.valueOf(commentPage.getSize()));
            return Result.success((Object)pageResult);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u7528\u6237\u8bc4\u8bba\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private CommentResponse convertToResponse(Comment comment) {
        Integer likeCount;
        CommentResponse response = new CommentResponse();
        BeanUtils.copyProperties((Object)comment, (Object)response);
        User user = (User)this.userMapper.selectById((Serializable)comment.getUserId());
        if (user != null) {
            response.setUserName(user.getUsername());
            response.setUserAvatar(user.getAvatarUrl());
        }
        response.setLikeCount(Integer.valueOf((likeCount = this.likeService.getLikeCount(comment.getId())) != null ? likeCount : 0));
        return response;
    }
}

