/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.service.impl;

import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.EmailService;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl
implements EmailService {
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${spring.mail.username}")
    private String fromEmail;
    private final Map<String, String> verificationCodes = new ConcurrentHashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public Result<Void> sendVerificationCode(String email, String code) {
        try {
            this.verificationCodes.put(email, code);
            this.scheduler.schedule(() -> this.verificationCodes.remove(email), 5L, TimeUnit.MINUTES);
            if (this.isRealEmailConfigured()) {
                this.sendRealEmail(email, code);
            } else {
                System.out.println("\u90ae\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574\uff0c\u6a21\u62df\u53d1\u9001\u9a8c\u8bc1\u7801\u5230\u90ae\u7bb1: " + email + ", \u9a8c\u8bc1\u7801: " + code);
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private boolean isRealEmailConfigured() {
        return this.fromEmail != null && !this.fromEmail.equals("your-email@qq.com") && !this.fromEmail.isEmpty();
    }

    private void sendRealEmail(String toEmail, String code) {
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(this.fromEmail);
            message.setTo(toEmail);
            message.setSubject("\u4e2a\u4eba\u535a\u5ba2\u7cfb\u7edf - \u9a8c\u8bc1\u7801");
            message.setText("\u60a8\u7684\u9a8c\u8bc1\u7801\u662f: " + code + "\n\n\u9a8c\u8bc1\u7801\u6709\u6548\u671f\u4e3a5\u5206\u949f\uff0c\u8bf7\u53ca\u65f6\u4f7f\u7528\u3002\n\n\u5982\u679c\u8fd9\u4e0d\u662f\u60a8\u7684\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u6b64\u90ae\u4ef6\u3002\n\n\u4e2a\u4eba\u535a\u5ba2\u7cfb\u7edf");
            this.mailSender.send(message);
            System.out.println("\u9a8c\u8bc1\u7801\u90ae\u4ef6\u5df2\u53d1\u9001\u5230: " + toEmail);
        }
        catch (Exception e) {
            System.err.println("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25: " + e.getMessage());
            System.out.println("\u5907\u7528\u65b9\u6848 - \u9a8c\u8bc1\u7801: " + code + " (\u90ae\u7bb1: " + toEmail + ")");
        }
    }

    public Result<Boolean> verifyCode(String email, String code) {
        try {
            String storedCode = (String)this.verificationCodes.get(email);
            if (storedCode == null) {
                return Result.error((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\u6216\u4e0d\u5b58\u5728");
            }
            if (storedCode.equals(code)) {
                this.verificationCodes.remove(email);
                return Result.success((Object)true);
            }
            return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        catch (Exception e) {
            return Result.error((String)("\u9a8c\u8bc1\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public String generateVerificationCode() {
        Random random = new Random();
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            code.append(random.nextInt(10));
        }
        return code.toString();
    }
}

