/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.service.impl;

import com.likeusewin10.dto.response.GameCategoryResponse;
import com.likeusewin10.dto.response.GameVideoResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.entity.Game;
import com.likeusewin10.mapper.GameMapper;
import com.likeusewin10.service.GameService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameServiceImpl
implements GameService {
    @Autowired
    private GameMapper gameMapper;

    public Result<List<GameCategoryResponse>> getGameCategories() {
        try {
            List categories = this.gameMapper.findAllCategories();
            ArrayList<GameCategoryResponse> responses = new ArrayList<GameCategoryResponse>();
            for (String category : categories) {
                List games = this.gameMapper.findByCategory(category);
                GameCategoryResponse response = new GameCategoryResponse();
                response.setGameName(category);
                response.setVideoCount(Integer.valueOf(games.size()));
                List videos = games.stream().map(game -> {
                    GameVideoResponse video = new GameVideoResponse();
                    BeanUtils.copyProperties((Object)game, (Object)video);
                    return video;
                }).collect(Collectors.toList());
                response.setVideos(videos);
                responses.add(response);
            }
            return Result.success(responses);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u6e38\u620f\u5206\u7c7b\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<PageResult<GameVideoResponse>> getGameVideos(String category, Integer current, Integer size) {
        try {
            long total;
            List games;
            int offset = (current - 1) * size;
            if (category != null && !category.isEmpty()) {
                games = this.gameMapper.findGamesByCategoryAndPage(category, offset, size.intValue());
                total = this.gameMapper.countGamesByCategory(category);
            } else {
                games = this.gameMapper.findGamesByPage(offset, size.intValue());
                total = this.gameMapper.countGames();
            }
            List responses = games.stream().map(game -> {
                GameVideoResponse response = new GameVideoResponse();
                BeanUtils.copyProperties((Object)game, (Object)response);
                return response;
            }).collect(Collectors.toList());
            PageResult result = new PageResult(responses, Long.valueOf(total), Long.valueOf(current.intValue()), Long.valueOf(size.intValue()));
            return Result.success((Object)result);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u6e38\u620f\u89c6\u9891\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<GameVideoResponse> getGameById(Long id) {
        try {
            Game game = this.gameMapper.findGameById(id);
            if (game == null) {
                return Result.error((String)"\u6e38\u620f\u4e0d\u5b58\u5728");
            }
            GameVideoResponse response = new GameVideoResponse();
            BeanUtils.copyProperties((Object)game, (Object)response);
            return Result.success((Object)response);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u6e38\u620f\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<PageResult<GameVideoResponse>> searchGameVideos(String keyword, Integer current, Integer size) {
        try {
            long total;
            List games;
            int offset = (current - 1) * size;
            if (keyword != null && !keyword.trim().isEmpty()) {
                games = this.gameMapper.searchGamesByPage(keyword, offset, size.intValue());
                total = this.gameMapper.countSearchGames(keyword);
            } else {
                games = this.gameMapper.findGamesByPage(offset, size.intValue());
                total = this.gameMapper.countGames();
            }
            List responses = games.stream().map(game -> {
                GameVideoResponse response = new GameVideoResponse();
                BeanUtils.copyProperties((Object)game, (Object)response);
                return response;
            }).collect(Collectors.toList());
            PageResult result = new PageResult(responses, Long.valueOf(total), Long.valueOf(current.intValue()), Long.valueOf(size.intValue()));
            return Result.success((Object)result);
        }
        catch (Exception e) {
            return Result.error((String)("\u641c\u7d22\u6e38\u620f\u89c6\u9891\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

