/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.service.impl;

import com.likeusewin10.dto.response.MusicResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.entity.Music;
import com.likeusewin10.mapper.MusicMapper;
import com.likeusewin10.service.MusicService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MusicServiceImpl
implements MusicService {
    @Autowired
    private MusicMapper musicMapper;

    public Result<PageResult<MusicResponse>> getMusicList(Integer current, Integer size) {
        try {
            int offset = (current - 1) * size;
            List musicList = this.musicMapper.findMusicByPage(offset, size.intValue());
            long total = this.musicMapper.countMusic();
            List responses = musicList.stream().map(music -> {
                MusicResponse response = new MusicResponse();
                BeanUtils.copyProperties((Object)music, (Object)response);
                return response;
            }).collect(Collectors.toList());
            PageResult result = new PageResult(responses, Long.valueOf(total), Long.valueOf(current.intValue()), Long.valueOf(size.intValue()));
            return Result.success((Object)result);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u97f3\u4e50\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<MusicResponse> getMusicById(Long id) {
        try {
            Music music = this.musicMapper.findMusicById(id);
            if (music == null) {
                return Result.error((String)"\u97f3\u4e50\u4e0d\u5b58\u5728");
            }
            MusicResponse response = new MusicResponse();
            BeanUtils.copyProperties((Object)music, (Object)response);
            return Result.success((Object)response);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u97f3\u4e50\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<PageResult<MusicResponse>> searchMusic(String keyword, Integer current, Integer size) {
        try {
            long total;
            List musicList;
            int offset = (current - 1) * size;
            if (keyword != null && !keyword.trim().isEmpty()) {
                musicList = this.musicMapper.searchMusicByPage(keyword, offset, size.intValue());
                total = this.musicMapper.countSearchMusic(keyword);
            } else {
                musicList = this.musicMapper.findMusicByPage(offset, size.intValue());
                total = this.musicMapper.countMusic();
            }
            List responses = musicList.stream().map(music -> {
                MusicResponse response = new MusicResponse();
                BeanUtils.copyProperties((Object)music, (Object)response);
                return response;
            }).collect(Collectors.toList());
            PageResult result = new PageResult(responses, Long.valueOf(total), Long.valueOf(current.intValue()), Long.valueOf(size.intValue()));
            return Result.success((Object)result);
        }
        catch (Exception e) {
            return Result.error((String)("\u641c\u7d22\u97f3\u4e50\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

