/*
 * Decompiled with CFR 0.152.
 */
package com.likeusewin10.service.impl;

import com.likeusewin10.dto.request.ForgotPasswordRequest;
import com.likeusewin10.dto.request.LoginRequest;
import com.likeusewin10.dto.request.RegisterRequest;
import com.likeusewin10.dto.request.ResetPasswordRequest;
import com.likeusewin10.dto.request.UpdatePasswordRequest;
import com.likeusewin10.dto.request.VerifyCodeRequest;
import com.likeusewin10.dto.response.LoginResponse;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.dto.response.UserResponse;
import com.likeusewin10.entity.User;
import com.likeusewin10.mapper.UserMapper;
import com.likeusewin10.service.CaptchaService;
import com.likeusewin10.service.EmailService;
import com.likeusewin10.service.UserService;
import com.likeusewin10.util.JwtUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private EmailService emailService;
    @Autowired
    private CaptchaService captchaService;

    public Result<LoginResponse> login(LoginRequest request, HttpServletRequest httpRequest) {
        try {
            if (request.getCaptcha() == null || request.getCaptcha().trim().isEmpty()) {
                return Result.error((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            }
            if (request.getCaptchaId() == null || request.getCaptchaId().trim().isEmpty()) {
                return Result.error((String)"\u9a8c\u8bc1\u7801ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!this.captchaService.verifyCaptcha(request.getCaptchaId(), request.getCaptcha(), httpRequest)) {
                return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f");
            }
            User user = this.userMapper.findByUsername(request.getUsername());
            if (user == null) {
                return Result.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            String encryptedPassword = DigestUtils.md5DigestAsHex((byte[])request.getPassword().getBytes());
            if (!encryptedPassword.equals(user.getPassword())) {
                return Result.error((String)"\u5bc6\u7801\u9519\u8bef");
            }
            if (user.getStatus() != 1) {
                return Result.error((String)"\u7528\u6237\u5df2\u88ab\u7981\u7528");
            }
            String token = JwtUtil.generateToken((Long)user.getId(), (String)user.getUsername());
            UserResponse userResponse = new UserResponse();
            BeanUtils.copyProperties((Object)user, (Object)userResponse);
            LoginResponse loginResponse = new LoginResponse(token, userResponse);
            return Result.success((String)"\u767b\u5f55\u6210\u529f", (Object)loginResponse);
        }
        catch (Exception e) {
            return Result.error((String)("\u767b\u5f55\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> register(RegisterRequest request, HttpServletRequest httpRequest) {
        try {
            if (request.getCaptcha() == null || request.getCaptcha().trim().isEmpty()) {
                return Result.error((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            }
            if (request.getCaptchaId() == null || request.getCaptchaId().trim().isEmpty()) {
                return Result.error((String)"\u9a8c\u8bc1\u7801ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!this.captchaService.verifyCaptcha(request.getCaptchaId(), request.getCaptcha(), httpRequest)) {
                return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f");
            }
            if (this.userMapper.findByUsername(request.getUsername()) != null) {
                return Result.error((String)"\u7528\u6237\u540d\u5df2\u5b58\u5728");
            }
            if (this.userMapper.findByEmail(request.getEmail()) != null) {
                return Result.error((String)"\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
            }
            User user = new User();
            user.setUsername(request.getUsername());
            user.setNickname(request.getNickname());
            user.setEmail(request.getEmail());
            user.setPassword(DigestUtils.md5DigestAsHex((byte[])request.getPassword().getBytes()));
            user.setRole("user");
            user.setStatus(Integer.valueOf(1));
            user.setCreatedAt(LocalDateTime.now());
            user.setUpdatedAt(LocalDateTime.now());
            this.userMapper.insert((Object)user);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u6ce8\u518c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<UserResponse> getUserInfo(Long userId) {
        try {
            User user = (User)this.userMapper.selectById((Serializable)userId);
            if (user == null) {
                return Result.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            UserResponse response = new UserResponse();
            BeanUtils.copyProperties((Object)user, (Object)response);
            response.setCreatedAt(user.getCreatedAt());
            return Result.success((Object)response);
        }
        catch (Exception e) {
            return Result.error((String)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> updateUserInfo(Long userId, UserResponse userInfo) {
        try {
            User user = (User)this.userMapper.selectById((Serializable)userId);
            if (user == null) {
                return Result.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            user.setNickname(userInfo.getNickname());
            user.setEmail(userInfo.getEmail());
            user.setAvatarUrl(userInfo.getAvatarUrl());
            user.setUpdatedAt(LocalDateTime.now());
            this.userMapper.updateById((Object)user);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> sendForgotPasswordCode(ForgotPasswordRequest request) {
        try {
            User user = this.userMapper.findByEmail(request.getEmail());
            if (user == null) {
                return Result.error((String)"\u8be5\u90ae\u7bb1\u672a\u6ce8\u518c");
            }
            String code = this.emailService.generateVerificationCode();
            Result sendResult = this.emailService.sendVerificationCode(request.getEmail(), code);
            if (!sendResult.isSuccess()) {
                return sendResult;
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> verifyEmailCode(VerifyCodeRequest request) {
        try {
            Result verifyResult = this.emailService.verifyCode(request.getEmail(), request.getVerificationCode());
            if (!verifyResult.isSuccess()) {
                return Result.error((String)verifyResult.getMessage());
            }
            if (!((Boolean)verifyResult.getData()).booleanValue()) {
                return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u9a8c\u8bc1\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> resetPassword(ResetPasswordRequest request) {
        try {
            Result verifyResult = this.emailService.verifyCode(request.getEmail(), request.getVerificationCode());
            if (!verifyResult.isSuccess()) {
                return Result.error((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
            }
            if (!((Boolean)verifyResult.getData()).booleanValue()) {
                return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
            User user = this.userMapper.findByEmail(request.getEmail());
            if (user == null) {
                return Result.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            user.setPassword(DigestUtils.md5DigestAsHex((byte[])request.getNewPassword().getBytes()));
            user.setUpdatedAt(LocalDateTime.now());
            this.userMapper.updateById((Object)user);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Void> updatePassword(Long userId, UpdatePasswordRequest request, HttpServletRequest httpRequest) {
        try {
            if (request.getCaptcha() == null || request.getCaptcha().trim().isEmpty()) {
                return Result.error((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            }
            if (request.getCaptchaId() == null || request.getCaptchaId().trim().isEmpty()) {
                return Result.error((String)"\u9a8c\u8bc1\u7801ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!this.captchaService.verifyCaptcha(request.getCaptchaId(), request.getCaptcha(), httpRequest)) {
                return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f");
            }
            User user = (User)this.userMapper.selectById((Serializable)userId);
            if (user == null) {
                return Result.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
            String encryptedCurrentPassword = DigestUtils.md5DigestAsHex((byte[])request.getCurrentPassword().getBytes());
            if (!encryptedCurrentPassword.equals(user.getPassword())) {
                return Result.error((String)"\u5f53\u524d\u5bc6\u7801\u9519\u8bef");
            }
            user.setPassword(DigestUtils.md5DigestAsHex((byte[])request.getNewPassword().getBytes()));
            user.setUpdatedAt(LocalDateTime.now());
            this.userMapper.updateById((Object)user);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Boolean> checkUsernameExists(String username) {
        try {
            User user = this.userMapper.findByUsername(username);
            return Result.success((Object)(user != null ? 1 : 0));
        }
        catch (Exception e) {
            return Result.error((String)("\u68c0\u67e5\u7528\u6237\u540d\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Result<Boolean> checkEmailExists(String email) {
        try {
            User user = this.userMapper.findByEmail(email);
            return Result.success((Object)(user != null ? 1 : 0));
        }
        catch (Exception e) {
            return Result.error((String)("\u68c0\u67e5\u90ae\u7bb1\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

