# Docker MySQL 8.0.36 部署和数据迁移指南

## 概述
本指南将帮助您将项目从本地MySQL迁移到Docker容器化的MySQL 8.0.36环境，实现与阿里云服务器相同的部署方式。

## 前置条件
- 已安装Docker和Docker Compose
- 本地MySQL服务正在运行且包含需要迁移的数据
- 确保本地MySQL可以正常连接

## 步骤1：备份本地数据

### 1.1 执行数据备份
```bash
# 运行备份脚本
.\backup-data.bat
```

### 1.2 手动备份（可选）
如果脚本执行失败，可以手动执行：
```bash
mysqldump -h127.0.0.1 -P3306 -umusicgame_user -pmusicgame123 --single-transaction --routines --triggers musicgame_db > musicgame_db_backup.sql
```

## 步骤2：停止本地MySQL服务
为避免端口冲突，需要停止本地MySQL服务：

### Windows:
```bash
# 以管理员身份运行命令提示符
net stop mysql
# 或者
net stop mysql80
```

### 或者修改本地MySQL端口
如果不想停止本地MySQL，可以修改docker-compose.yml中的端口映射：
```yaml
ports:
  - "3307:3306"  # 将Docker MySQL映射到3307端口
```

## 步骤3：启动Docker MySQL容器

### 3.1 启动MySQL容器
```bash
# 只启动MySQL服务
docker-compose up -d mysql

# 查看容器状态
docker-compose ps

# 查看MySQL启动日志
docker-compose logs mysql
```

### 3.2 等待MySQL完全启动
等待看到类似以下日志信息：
```
[Server] /usr/sbin/mysqld: ready for connections.
```

## 步骤4：导入备份数据

### 4.1 使用导入脚本
```bash
# 使用之前备份的文件名
.\import-data.bat musicgame_db_backup_20241201_143022.sql
```

### 4.2 手动导入（可选）
```bash
# 复制备份文件到容器
docker cp musicgame_db_backup.sql personal-blog-mysql:/tmp/

# 进入容器并导入数据
docker exec -it personal-blog-mysql mysql -umusicgame_user -pmusicgame123 musicgame_db < /tmp/musicgame_db_backup.sql
```

## 步骤5：验证数据迁移

### 5.1 连接到Docker MySQL
```bash
# 进入MySQL容器
docker exec -it personal-blog-mysql mysql -umusicgame_user -pmusicgame123 musicgame_db

# 检查表和数据
SHOW TABLES;
SELECT COUNT(*) FROM users;
SELECT COUNT(*) FROM games;
SELECT COUNT(*) FROM articles;
```

### 5.2 测试应用连接
```bash
# 启动后端服务
docker-compose up -d backend

# 查看后端日志
docker-compose logs backend
```

## 步骤6：完整部署

### 6.1 构建并启动所有服务
```bash
# 构建并启动所有服务
docker-compose up -d

# 查看所有服务状态
docker-compose ps
```

### 6.2 访问应用
- 前端：http://localhost
- 后端API：http://localhost:8080
- MySQL：localhost:3306

## 配置说明

### Docker Compose配置
当前的docker-compose.yml已经配置了：
- MySQL 8.0.36镜像
- 数据持久化卷
- 网络配置
- 环境变量

### 应用配置
- 开发环境：使用`application.yml`（连接本地MySQL）
- 生产环境：使用`application-prod.yml`（连接Docker MySQL）

## 常见问题解决

### 问题1：端口冲突
```bash
# 检查端口占用
netstat -ano | findstr :3306

# 停止本地MySQL或修改Docker端口映射
```

### 问题2：容器启动失败
```bash
# 查看详细日志
docker-compose logs mysql

# 重新创建容器
docker-compose down
docker-compose up -d mysql
```

### 问题3：数据导入失败
```bash
# 检查备份文件编码
# 确保备份文件使用UTF-8编码

# 手动进入容器检查
docker exec -it personal-blog-mysql bash
```

### 问题4：应用连接数据库失败
检查以下配置：
- 数据库URL中的主机名（应该是`mysql`而不是`localhost`）
- 用户名和密码
- 数据库名称

## 数据库管理

### 备份Docker中的数据
```bash
# 定期备份
docker exec personal-blog-mysql mysqldump -umusicgame_user -pmusicgame123 musicgame_db > backup_$(date +%Y%m%d_%H%M%S).sql
```

### 查看数据库状态
```bash
# 查看数据库大小
docker exec personal-blog-mysql mysql -umusicgame_user -pmusicgame123 -e "SELECT table_schema AS 'Database', ROUND(SUM(data_length + index_length) / 1024 / 1024, 2) AS 'Size (MB)' FROM information_schema.tables WHERE table_schema='musicgame_db';"
```

## 性能优化建议

1. **内存配置**：根据服务器内存调整MySQL配置
2. **数据卷**：使用命名卷而不是绑定挂载以提高性能
3. **网络**：使用自定义网络提高容器间通信效率
4. **日志**：配置日志轮转避免日志文件过大

## 安全建议

1. **密码安全**：使用强密码并定期更换
2. **网络安全**：不要将MySQL端口暴露到公网
3. **数据备份**：定期备份数据到安全位置
4. **权限控制**：使用最小权限原则配置数据库用户

完成以上步骤后，您的应用就成功迁移到Docker化的MySQL 8.0.36环境了！