import { createRouter, createWebHistory } from 'vue-router'
import HomePage from '../components/HomePage.vue'
import CodePage from '../components/CodePage.vue'
import GamePage from '../components/GamePage.vue'
import MusicPage from '../components/MusicPage.vue'
import ForumPage from '../components/ForumPage.vue'
import LoginPage from '../components/LoginPage.vue'
import ProfileEditPage from '../components/ProfileEditPage.vue'
import AboutPage from '../components/AboutPage.vue'

const routes = [
  {
    path: '/',
    name: 'Home',
    component: HomePage
  },
  {
    path: '/code',
    name: 'Code',
    component: CodePage
  },
  {
    path: '/game',
    name: 'Game',
    component: GamePage
  },
  {
    path: '/music',
    name: 'Music',
    component: MusicPage
  },
  {
    path: '/forum',
    name: 'Forum',
    component: ForumPage
  },
  {
    path: '/login',
    name: 'Login',
    component: LoginPage
  },
  {
    path: '/profile-edit',
    name: 'ProfileEdit',
    component: ProfileEditPage
  },
  {
    path: '/about',
    name: 'About',
    component: AboutPage
  }
]

const router = createRouter({
  history: createWebHistory(),
  routes
})

export default router