const axios = require('axios');

// 测试发布文章接口
async function testCreateArticle() {
    console.log('开始测试发布文章接口...');
    
    try {
        // 1. 获取验证码
        console.log('1. 获取验证码...');
        const captchaResponse = await axios.get('http://localhost:8080/api/captcha');
        console.log('验证码响应:', captchaResponse.data);
        
        if (!captchaResponse.data.success) {
            console.log('获取验证码失败，跳过登录测试...');
            return;
        }
        
        const captchaId = captchaResponse.data.data.id;
        
        // 2. 尝试登录获取token（使用测试账号）
        console.log('2. 尝试登录获取token...');
        const loginResponse = await axios.post('http://localhost:8080/api/user/login', {
            username: 'testuser123',
            password: '123456',
            captcha: '1234', // 使用固定验证码进行测试
            captchaId: captchaId
        });
        
        console.log('登录响应:', loginResponse.data);
        
        let token = null;
        if (loginResponse.data.success && loginResponse.data.data.token) {
            token = loginResponse.data.data.token;
            console.log('✅ 登录成功，获得token');
        } else {
            console.log('❌ 登录失败，尝试不使用token直接测试...');
        }
        
        // 3. 测试发布文章
        console.log('3. 测试发布文章...');
        const articleData = {
            title: '测试文章标题',
            summary: '这是一个测试文章的摘要',
            content: '这是测试文章的内容，包含一些文本。',
            category: '技术',
            coverUrl: ''
        };
        
        console.log('发送的文章数据:', articleData);
        
        const headers = {};
        if (token) {
            headers.Authorization = `Bearer ${token}`;
        }
        
        const createResponse = await axios.post('http://localhost:8080/api/article', articleData, {
            headers: headers
        });
        
        console.log('发布文章响应:', createResponse.data);
        
        if (createResponse.data.success) {
            console.log('✅ 发布文章成功!');
            console.log('文章ID:', createResponse.data.data);
        } else {
            console.log('❌ 发布文章失败:', createResponse.data.message);
        }
        
    } catch (error) {
        console.log('❌ 测试过程中发生错误:');
        if (error.response) {
            console.log('响应状态:', error.response.status);
            console.log('响应数据:', error.response.data);
        } else {
            console.log('错误信息:', error.message);
        }
    }
}

// 运行测试
testCreateArticle();