package com.likeusewin10;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * 个人博客系统启动类
 * 
 * @author likeusewin10
 * @since 2025-01-10
 */
@SpringBootApplication
@MapperScan("com.likeusewin10.mapper")
@EnableTransactionManagement
public class PersonalBlogApplication {
    
    public static void main(String[] args) {
        SpringApplication.run(PersonalBlogApplication.class, args);
        System.out.println("\n==================================");
        System.out.println("个人博客系统启动成功！");
        System.out.println("API文档地址: http://localhost:8080/api/swagger-ui/");
        System.out.println("==================================");
    }
}