package com.likeusewin10.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class CorsConfig implements WebMvcConfigurer {
    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
                .allowedOriginPatterns(
                    "http://likeusewin10.xyz",
                    "https://likeusewin10.xyz", 
                    "http://localhost:*",
                    "http://127.0.0.1:*"
                ) // 允许的源
                .allowedMethods("GET", "POST", "PUT", "DELETE", "OPTIONS") // 允许的方法
                .allowedHeaders("Content-Type", "Authorization", "X-Requested-With", "Accept", "Origin") // 允许的头部
                .allowCredentials(true) // 允许凭证
                .maxAge(3600); // 预检请求缓存时间
    }
}
