package com.likeusewin10.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig implements WebMvcConfigurer {
    
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        // 配置游戏视频静态资源访问
        registry.addResourceHandler("/games/**")
                .addResourceLocations("file:" + System.getProperty("user.dir") + "/Vue3/public/games/");
        
        // 配置音乐文件静态资源访问
        registry.addResourceHandler("/music/**")
                .addResourceLocations("file:" + System.getProperty("user.dir") + "/Vue3/public/music/");
        
        // 配置图片静态资源访问
        registry.addResourceHandler("/images/**")
                .addResourceLocations("file:" + System.getProperty("user.dir") + "/Vue3/public/images/");
        
        // 配置视频静态资源访问
        registry.addResourceHandler("/videos/**")
                .addResourceLocations("file:" + System.getProperty("user.dir") + "/Vue3/public/videos/");
        
        // 配置上传文件访问
        registry.addResourceHandler("/uploads/**")
                .addResourceLocations("file:uploads/");
    }
}