package com.likeusewin10.controller;

import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.CaptchaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@RestController
@RequestMapping("/api")
public class CaptchaController {
    
    @Autowired
    private CaptchaService captchaService;
    
    /**
     * 生成验证码
     */
    @GetMapping("/captcha")
    public Result<Map<String, Object>> generateCaptcha(HttpServletRequest request) {
        try {
            Map<String, Object> captchaData = captchaService.generateCaptcha(request);
            return Result.success(captchaData);
        } catch (Exception e) {
            return Result.error("生成验证码失败：" + e.getMessage());
        }
    }
    
    /**
     * 验证验证码
     */
    @PostMapping("/captcha/verify")
    public Result<Boolean> verifyCaptcha(@RequestBody Map<String, String> request, HttpServletRequest httpRequest) {
        try {
            String captchaId = request.get("captchaId");
            String captcha = request.get("captcha");
            
            boolean isValid = captchaService.verifyCaptcha(captchaId, captcha, httpRequest);
            return Result.success(isValid);
        } catch (Exception e) {
            return Result.error("验证码验证失败：" + e.getMessage());
        }
    }
}