package com.likeusewin10.controller;

import com.likeusewin10.dto.response.GameCategoryResponse;
import com.likeusewin10.dto.response.GameVideoResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.GameService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/game")
public class GameController {
    
    @Autowired
    private GameService gameService;
    
    /**
     * 获取游戏分类列表
     */
    @GetMapping("/categories")
    public Result<List<GameCategoryResponse>> getGameCategories() {
        return gameService.getGameCategories();
    }
    
    /**
     * 获取游戏视频列表
     */
    @GetMapping("/videos")
    public Result<PageResult<GameVideoResponse>> getGameVideos(
            @RequestParam(defaultValue = "1") int current,
            @RequestParam(defaultValue = "10") int size,
            @RequestParam(required = false) String category) {
        return gameService.getGameVideos(category, current, size);
    }
    
    /**
     * 获取游戏视频详情
     */
    @GetMapping("/videos/{id}")
    public Result<GameVideoResponse> getGameVideoById(@PathVariable Long id) {
        return gameService.getGameById(id);
    }
    
    /**
     * 搜索游戏视频
     */
    @GetMapping("/search")
    public Result<PageResult<GameVideoResponse>> searchGameVideos(
            @RequestParam String keyword,
            @RequestParam(defaultValue = "1") int current,
            @RequestParam(defaultValue = "10") int size) {
        return gameService.searchGameVideos(keyword, current, size);
    }
}