package com.likeusewin10.controller;

import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.LikeService;
import com.likeusewin10.util.IpUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 点赞控制器
 * 
 * @author likeusewin10
 * @since 2025-01-10
 */
@RestController
@RequestMapping("/api/like")
public class LikeController {
    
    @Autowired
    private LikeService likeService;
    
    /**
     * 切换点赞状态
     * 
     * @param commentId 评论ID
     * @param request HTTP请求对象
     * @return 操作结果
     */
    @PostMapping("/toggle/{commentId}")
    public Result<Map<String, Object>> toggleLike(
            @PathVariable Long commentId,
            HttpServletRequest request) {
        
        String ipAddress = IpUtil.getClientIpAddress(request);
        String message = likeService.toggleLike(commentId, ipAddress);
        Integer likeCount = likeService.getLikeCount(commentId);
        boolean hasLiked = likeService.hasLiked(commentId, ipAddress);
        
        Map<String, Object> response = new HashMap<>();
        response.put("message", message);
        response.put("likeCount", likeCount);
        response.put("hasLiked", hasLiked);
        
        return Result.success("操作成功", response);
    }
    
    /**
     * 获取评论点赞数量
     * 
     * @param commentId 评论ID
     * @return 点赞数量
     */
    @GetMapping("/count/{commentId}")
    public Result<Map<String, Object>> getLikeCount(@PathVariable Long commentId) {
        Integer likeCount = likeService.getLikeCount(commentId);
        
        Map<String, Object> response = new HashMap<>();
        response.put("likeCount", likeCount);
        
        return Result.success("获取成功", response);
    }
    
    /**
     * 检查是否已点赞
     * 
     * @param commentId 评论ID
     * @param request HTTP请求对象
     * @return 是否已点赞
     */
    @GetMapping("/check/{commentId}")
    public Result<Map<String, Object>> checkLikeStatus(
            @PathVariable Long commentId,
            HttpServletRequest request) {
        
        String ipAddress = IpUtil.getClientIpAddress(request);
        boolean hasLiked = likeService.hasLiked(commentId, ipAddress);
        
        Map<String, Object> response = new HashMap<>();
        response.put("hasLiked", hasLiked);
        
        return Result.success("获取成功", response);
    }
}