package com.likeusewin10.controller;

import com.likeusewin10.dto.response.MusicResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.service.MusicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;

@RestController
@RequestMapping("/api/music")
public class MusicController {
    
    @Autowired
    private MusicService musicService;
    
    /**
     * 获取音乐列表
     */
    @GetMapping("/list")
    public Result<PageResult<MusicResponse>> getMusicList(
            @RequestParam(defaultValue = "1") int current,
            @RequestParam(defaultValue = "10") int size,
            @RequestParam(required = false) String genre) {
        return musicService.getMusicList(current, size);
    }
    
    /**
     * 获取音乐详情
     */
    @GetMapping("/{id}")
    public Result<MusicResponse> getMusicById(@PathVariable Long id) {
        return musicService.getMusicById(id);
    }
    
    /**
     * 搜索音乐
     */
    @GetMapping("/search")
    public Result<PageResult<MusicResponse>> searchMusic(
            @RequestParam String keyword,
            @RequestParam(defaultValue = "1") int current,
            @RequestParam(defaultValue = "10") int size) {
        return musicService.searchMusic(keyword, current, size);
    }
    
    /**
     * 获取热门音乐
     */
    @GetMapping("/hot")
    public Result<PageResult<MusicResponse>> getHotMusic(
            @RequestParam(defaultValue = "1") int current,
            @RequestParam(defaultValue = "10") int size) {
        // 热门音乐功能暂未实现，返回普通音乐列表
        return musicService.getMusicList(current, size);
    }
}