package com.likeusewin10.controller;

import com.likeusewin10.dto.response.Result;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/api/test")
public class TestController {
    
    /**
     * 健康检查接口
     */
    @GetMapping("/health")
    public Result<Map<String, Object>> health() {
        Map<String, Object> data = new HashMap<>();
        data.put("status", "ok");
        data.put("message", "个人博客后端服务运行正常");
        data.put("timestamp", LocalDateTime.now());
        data.put("version", "1.0.0");
        
        return Result.success(data);
    }
    
    /**
     * 简单的 Hello World 接口
     */
    @GetMapping("/hello")
    public Result<String> hello() {
        return Result.success("Hello, 个人博客系统!");
    }
}