package com.likeusewin10.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.likeusewin10.entity.Article;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface ArticleMapper extends BaseMapper<Article> {
    
    @Select("SELECT * FROM articles WHERE user_id = #{userId} ORDER BY created_time DESC")
    List<Article> findByUserId(Long userId);
    
    @Select("SELECT * FROM articles WHERE title LIKE CONCAT('%', #{keyword}, '%') OR content LIKE CONCAT('%', #{keyword}, '%') ORDER BY created_time DESC")
    List<Article> searchByKeyword(String keyword);
}