package com.likeusewin10.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.likeusewin10.entity.Comment;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface CommentMapper extends BaseMapper<Comment> {
    
    @Select("SELECT * FROM comments WHERE article_id = #{articleId} ORDER BY created_at DESC")
    List<Comment> findByArticleId(Long articleId);
    
    @Select("SELECT * FROM comments WHERE user_id = #{userId} ORDER BY created_at DESC")
    List<Comment> findByUserId(Long userId);
}