package com.likeusewin10.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.likeusewin10.entity.Game;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface GameMapper extends BaseMapper<Game> {
    
    @Select("SELECT DISTINCT category FROM games WHERE category IS NOT NULL AND category != ''")
    List<String> findAllCategories();
    
    @Select("SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE category = #{category} ORDER BY created_at DESC")
    List<Game> findByCategory(String category);
    
    @Select("SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE status = 1 ORDER BY created_at DESC LIMIT #{offset}, #{size}")
    List<Game> findGamesByPage(@Param("offset") int offset, @Param("size") int size);
    
    @Select("SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE category = #{category} AND status = 1 ORDER BY created_at DESC LIMIT #{offset}, #{size}")
    List<Game> findGamesByCategoryAndPage(@Param("category") String category, @Param("offset") int offset, @Param("size") int size);
    
    @Select("SELECT COUNT(*) FROM games WHERE status = 1")
    long countGames();
    
    @Select("SELECT COUNT(*) FROM games WHERE category = #{category} AND status = 1")
    long countGamesByCategory(@Param("category") String category);
    
    @Select("SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE (title LIKE CONCAT('%', #{keyword}, '%') OR category LIKE CONCAT('%', #{keyword}, '%') OR description LIKE CONCAT('%', #{keyword}, '%')) AND status = 1 ORDER BY created_at DESC LIMIT #{offset}, #{size}")
    List<Game> searchGamesByPage(@Param("keyword") String keyword, @Param("offset") int offset, @Param("size") int size);
    
    @Select("SELECT COUNT(*) FROM games WHERE (title LIKE CONCAT('%', #{keyword}, '%') OR category LIKE CONCAT('%', #{keyword}, '%') OR description LIKE CONCAT('%', #{keyword}, '%')) AND status = 1")
    long countSearchGames(@Param("keyword") String keyword);
    
    @Select("SELECT id, title, description, category, video_url, thumbnail, duration, views, likes, status, created_at, updated_at FROM games WHERE id = #{id}")
    Game findGameById(@Param("id") Long id);
}