package com.likeusewin10.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.likeusewin10.entity.Like;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 点赞Mapper接口
 * 
 * @author likeusewin10
 * @since 2025-01-10
 */
@Mapper
public interface LikeMapper extends BaseMapper<Like> {
    
    /**
     * 根据评论ID和IP地址查询点赞记录
     * 
     * @param commentId 评论ID
     * @param ipAddress IP地址
     * @return 点赞记录
     */
    @Select("SELECT * FROM likes WHERE comment_id = #{commentId} AND ip_address = #{ipAddress}")
    Like findByCommentIdAndIpAddress(@Param("commentId") Long commentId, @Param("ipAddress") String ipAddress);
    
    /**
     * 根据评论ID统计点赞数量
     * 
     * @param commentId 评论ID
     * @return 点赞数量
     */
    @Select("SELECT COUNT(*) FROM likes WHERE comment_id = #{commentId}")
    Integer countByCommentId(@Param("commentId") Long commentId);
}