package com.likeusewin10.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.likeusewin10.entity.Music;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface MusicMapper extends BaseMapper<Music> {
    
    @Select("SELECT id, title, artist, album, genre, audio_url, cover_image, duration, play_count, likes, status, created_at, updated_at FROM music WHERE status = 1 ORDER BY created_at DESC LIMIT #{offset}, #{size}")
    List<Music> findMusicByPage(@Param("offset") int offset, @Param("size") int size);
    
    @Select("SELECT COUNT(*) FROM music WHERE status = 1")
    long countMusic();
    
    @Select("SELECT id, title, artist, album, genre, audio_url, cover_image, duration, play_count, likes, status, created_at, updated_at FROM music WHERE id = #{id}")
    Music findMusicById(@Param("id") Long id);
    
    @Select("SELECT id, title, artist, album, genre, audio_url, cover_image, duration, play_count, likes, status, created_at, updated_at FROM music WHERE (title LIKE CONCAT('%', #{keyword}, '%') OR artist LIKE CONCAT('%', #{keyword}, '%') OR album LIKE CONCAT('%', #{keyword}, '%')) AND status = 1 ORDER BY created_at DESC LIMIT #{offset}, #{size}")
    List<Music> searchMusicByPage(@Param("keyword") String keyword, @Param("offset") int offset, @Param("size") int size);
    
    @Select("SELECT COUNT(*) FROM music WHERE (title LIKE CONCAT('%', #{keyword}, '%') OR artist LIKE CONCAT('%', #{keyword}, '%') OR album LIKE CONCAT('%', #{keyword}, '%')) AND status = 1")
    long countSearchMusic(@Param("keyword") String keyword);
}