package com.likeusewin10.service;

import com.likeusewin10.dto.request.ArticleRequest;
import com.likeusewin10.dto.response.ArticleResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;

public interface ArticleService {
    
    Result<PageResult<ArticleResponse>> getArticleList(Integer current, Integer size);
    
    Result<ArticleResponse> getArticleById(Long id);
    
    Result<Void> createArticle(Long userId, ArticleRequest request);
    
    Result<Void> updateArticle(Long userId, Long articleId, ArticleRequest request);
    
    Result<Void> deleteArticle(Long userId, Long articleId);
    
    Result<PageResult<ArticleResponse>> searchArticles(String keyword, Integer current, Integer size);
    
    Result<PageResult<ArticleResponse>> getUserArticles(Long userId, Integer current, Integer size);
}