package com.likeusewin10.service;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

public interface CaptchaService {
    
    /**
     * 生成验证码
     * @param request HTTP请求
     * @return 验证码数据（包含图片和ID）
     */
    Map<String, Object> generateCaptcha(HttpServletRequest request);
    
    /**
     * 验证验证码
     * @param captchaId 验证码ID
     * @param captcha 用户输入的验证码
     * @param request HTTP请求
     * @return 验证结果
     */
    boolean verifyCaptcha(String captchaId, String captcha, HttpServletRequest request);
}