package com.likeusewin10.service;

import com.likeusewin10.dto.response.Result;

/**
 * 邮箱服务接口
 * 
 * @author likeusewin10
 * @since 2025-01-10
 */
public interface EmailService {
    
    /**
     * 发送验证码到指定邮箱
     * @param email 邮箱地址
     * @param code 验证码
     * @return 发送结果
     */
    Result<Void> sendVerificationCode(String email, String code);
    
    /**
     * 验证邮箱验证码
     * @param email 邮箱地址
     * @param code 验证码
     * @return 验证结果
     */
    Result<Boolean> verifyCode(String email, String code);
    
    /**
     * 生成验证码
     * @return 6位数字验证码
     */
    String generateVerificationCode();
}