package com.likeusewin10.service;

/**
 * 点赞服务接口
 * 
 * @author likeusewin10
 * @since 2025-01-10
 */
public interface LikeService {
    
    /**
     * 切换点赞状态（点赞/取消点赞）
     * 
     * @param commentId 评论ID
     * @param ipAddress IP地址
     * @return 操作结果消息
     */
    String toggleLike(Long commentId, String ipAddress);
    
    /**
     * 获取评论的点赞数量
     * 
     * @param commentId 评论ID
     * @return 点赞数量
     */
    Integer getLikeCount(Long commentId);
    
    /**
     * 检查IP是否已点赞
     * 
     * @param commentId 评论ID
     * @param ipAddress IP地址
     * @return 是否已点赞
     */
    boolean hasLiked(Long commentId, String ipAddress);
}