package com.likeusewin10.service;

import com.likeusewin10.dto.request.LoginRequest;
import com.likeusewin10.dto.request.RegisterRequest;
import com.likeusewin10.dto.request.ForgotPasswordRequest;
import com.likeusewin10.dto.request.VerifyCodeRequest;
import com.likeusewin10.dto.request.ResetPasswordRequest;
import com.likeusewin10.dto.request.UpdatePasswordRequest;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.dto.response.UserResponse;
import com.likeusewin10.dto.response.LoginResponse;
import javax.servlet.http.HttpServletRequest;

public interface UserService {
    
    Result<LoginResponse> login(LoginRequest request, HttpServletRequest httpRequest);
    
    Result<Void> register(RegisterRequest request, HttpServletRequest httpRequest);
    
    Result<UserResponse> getUserInfo(Long userId);
    
    Result<Void> updateUserInfo(Long userId, UserResponse userInfo);
    
    /**
     * 发送忘记密码验证码
     */
    Result<Void> sendForgotPasswordCode(ForgotPasswordRequest request);
    
    /**
     * 验证邮箱验证码
     */
    Result<Void> verifyEmailCode(VerifyCodeRequest request);
    
    /**
     * 重置密码
     */
    Result<Void> resetPassword(ResetPasswordRequest request);
    
    /**
     * 检查用户名是否存在
     */
    Result<Boolean> checkUsernameExists(String username);
    
    /**
     * 检查邮箱是否存在
     */
    Result<Boolean> checkEmailExists(String email);
    
    /**
     * 修改密码
     */
    Result<Void> updatePassword(Long userId, UpdatePasswordRequest request, HttpServletRequest httpRequest);
}