package com.likeusewin10.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.likeusewin10.dto.response.GameCategoryResponse;
import com.likeusewin10.dto.response.GameVideoResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.entity.Game;
import com.likeusewin10.mapper.GameMapper;
import com.likeusewin10.service.GameService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class GameServiceImpl implements GameService {
    
    @Autowired
    private GameMapper gameMapper;
    
    @Override
    public Result<List<GameCategoryResponse>> getGameCategories() {
        try {
            List<String> categories = gameMapper.findAllCategories();
            List<GameCategoryResponse> responses = new ArrayList<>();
            
            for (String category : categories) {
                List<Game> games = gameMapper.findByCategory(category);
                
                GameCategoryResponse response = new GameCategoryResponse();
                response.setGameName(category);
                response.setVideoCount(games.size());
                
                List<GameVideoResponse> videos = games.stream().map(game -> {
                    GameVideoResponse video = new GameVideoResponse();
                    BeanUtils.copyProperties(game, video);
                    return video;
                }).collect(Collectors.toList());
                
                response.setVideos(videos);
                responses.add(response);
            }
            
            return Result.success(responses);
            
        } catch (Exception e) {
            return Result.error("获取游戏分类失败：" + e.getMessage());
        }
    }
    
    @Override
    public Result<PageResult<GameVideoResponse>> getGameVideos(String category, Integer current, Integer size) {
        try {
            int offset = (current - 1) * size;
            List<Game> games;
            long total;
            
            if (category != null && !category.isEmpty()) {
                games = gameMapper.findGamesByCategoryAndPage(category, offset, size);
                total = gameMapper.countGamesByCategory(category);
            } else {
                games = gameMapper.findGamesByPage(offset, size);
                total = gameMapper.countGames();
            }
            
            List<GameVideoResponse> responses = games.stream().map(game -> {
                GameVideoResponse response = new GameVideoResponse();
                BeanUtils.copyProperties(game, response);
                return response;
            }).collect(Collectors.toList());
            
            PageResult<GameVideoResponse> result = new PageResult<>(
                responses, 
                total, 
                (long) current, 
                (long) size
            );
            
            return Result.success(result);
            
        } catch (Exception e) {
            return Result.error("获取游戏视频失败：" + e.getMessage());
        }
    }
    
    @Override
    public Result<GameVideoResponse> getGameById(Long id) {
        try {
            Game game = gameMapper.findGameById(id);
            if (game == null) {
                return Result.error("游戏不存在");
            }
            
            GameVideoResponse response = new GameVideoResponse();
            BeanUtils.copyProperties(game, response);
            
            return Result.success(response);
            
        } catch (Exception e) {
            return Result.error("获取游戏详情失败：" + e.getMessage());
        }
    }
    
    @Override
    public Result<PageResult<GameVideoResponse>> searchGameVideos(String keyword, Integer current, Integer size) {
        try {
            int offset = (current - 1) * size;
            List<Game> games;
            long total;
            
            if (keyword != null && !keyword.trim().isEmpty()) {
                games = gameMapper.searchGamesByPage(keyword, offset, size);
                total = gameMapper.countSearchGames(keyword);
            } else {
                games = gameMapper.findGamesByPage(offset, size);
                total = gameMapper.countGames();
            }
            
            List<GameVideoResponse> responses = games.stream().map(game -> {
                GameVideoResponse response = new GameVideoResponse();
                BeanUtils.copyProperties(game, response);
                return response;
            }).collect(Collectors.toList());
            
            PageResult<GameVideoResponse> result = new PageResult<>(
                responses, 
                total, 
                (long) current, 
                (long) size
            );
            
            return Result.success(result);
            
        } catch (Exception e) {
            return Result.error("搜索游戏视频失败：" + e.getMessage());
        }
    }
}