package com.likeusewin10.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.likeusewin10.entity.Like;
import com.likeusewin10.mapper.LikeMapper;
import com.likeusewin10.service.LikeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * 点赞服务实现类
 * 
 * @author likeusewin10
 * @since 2025-01-10
 */
@Service
public class LikeServiceImpl implements LikeService {
    
    @Autowired
    private LikeMapper likeMapper;
    
    @Override
    public String toggleLike(Long commentId, String ipAddress) {
        Like existingLike = likeMapper.findByCommentIdAndIpAddress(commentId, ipAddress);
        
        if (existingLike != null) {
            // 已点赞，取消点赞
            likeMapper.deleteById(existingLike.getId());
            return "取消点赞成功";
        } else {
            // 未点赞，添加点赞
            Like like = new Like();
            like.setCommentId(commentId);
            like.setIpAddress(ipAddress);
            like.setCreatedAt(LocalDateTime.now());
            likeMapper.insert(like);
            return "点赞成功";
        }
    }
    
    @Override
    public Integer getLikeCount(Long commentId) {
        return likeMapper.countByCommentId(commentId);
    }
    
    @Override
    public boolean hasLiked(Long commentId, String ipAddress) {
        Like like = likeMapper.findByCommentIdAndIpAddress(commentId, ipAddress);
        return like != null;
    }
}