package com.likeusewin10.service.impl;

import com.likeusewin10.dto.response.MusicResponse;
import com.likeusewin10.dto.response.PageResult;
import com.likeusewin10.dto.response.Result;
import com.likeusewin10.entity.Music;
import com.likeusewin10.mapper.MusicMapper;
import com.likeusewin10.service.MusicService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class MusicServiceImpl implements MusicService {
    
    @Autowired
    private MusicMapper musicMapper;
    
    @Override
    public Result<PageResult<MusicResponse>> getMusicList(Integer current, Integer size) {
        try {
            int offset = (current - 1) * size;
            List<Music> musicList = musicMapper.findMusicByPage(offset, size);
            long total = musicMapper.countMusic();
            
            List<MusicResponse> responses = musicList.stream().map(music -> {
                MusicResponse response = new MusicResponse();
                BeanUtils.copyProperties(music, response);
                return response;
            }).collect(Collectors.toList());
            
            PageResult<MusicResponse> result = new PageResult<>(
                responses, 
                total, 
                (long) current, 
                (long) size
            );
            
            return Result.success(result);
            
        } catch (Exception e) {
            return Result.error("获取音乐列表失败：" + e.getMessage());
        }
    }
    
    @Override
    public Result<MusicResponse> getMusicById(Long id) {
        try {
            Music music = musicMapper.findMusicById(id);
            if (music == null) {
                return Result.error("音乐不存在");
            }
            
            MusicResponse response = new MusicResponse();
            BeanUtils.copyProperties(music, response);
            
            return Result.success(response);
            
        } catch (Exception e) {
            return Result.error("获取音乐详情失败：" + e.getMessage());
        }
    }
    
    @Override
    public Result<PageResult<MusicResponse>> searchMusic(String keyword, Integer current, Integer size) {
        try {
            int offset = (current - 1) * size;
            List<Music> musicList;
            long total;
            
            if (keyword != null && !keyword.trim().isEmpty()) {
                musicList = musicMapper.searchMusicByPage(keyword, offset, size);
                total = musicMapper.countSearchMusic(keyword);
            } else {
                musicList = musicMapper.findMusicByPage(offset, size);
                total = musicMapper.countMusic();
            }
            
            List<MusicResponse> responses = musicList.stream().map(music -> {
                MusicResponse response = new MusicResponse();
                BeanUtils.copyProperties(music, response);
                return response;
            }).collect(Collectors.toList());
            
            PageResult<MusicResponse> result = new PageResult<>(
                responses, 
                total, 
                (long) current, 
                (long) size
            );
            
            return Result.success(result);
            
        } catch (Exception e) {
            return Result.error("搜索音乐失败：" + e.getMessage());
        }
    }
}