INSERT INTO `users` (`username`, `email`, `password`, `nickname`, `avatar`, `bio`, `role`) VALUES
('admin', 'admin@example.com', 'e10adc3949ba59abbe56e057f20f883e', '管理员', '/images/avatar/admin.jpg', '系统管理员', 'admin'),
('testuser', 'test@example.com', 'e10adc3949ba59abbe56e057f20f883e', '测试用户', '/images/avatar/user.jpg', '这是一个测试用户', 'user');

-- 插入测试游戏数据（根据实际文件路径修改）
INSERT INTO `games` (`title`, `description`, `category`, `video_url`, `thumbnail`, `duration`, `views`, `likes`) VALUES
('王者荣耀精彩操作', '王者荣耀游戏精彩操作集锦', '王者荣耀', '/games/王者荣耀/1.mp4', '/images/games/wangzhe_thumb.jpg', 1200, 1500, 89),
('金铲铲之战攻略', '金铲铲之战游戏攻略视频', '金铲铲之战', '/games/金铲铲之战/1.mp4', '/images/games/jinchanchan_thumb.jpg', 800, 2300, 156);

-- 插入测试音乐数据（根据实际文件路径修改）
INSERT INTO `music` (`title`, `artist`, `album`, `genre`, `audio_url`, `cover_image`, `duration`, `play_count`, `likes`) VALUES
('倒带', '周杰伦', 'Live专辑', '流行', '/music/周杰伦 - 倒带 (Live).mp3', '/images/music/daodai.jpg', 240, 5000, 320),
('茉莉雨', '林俊杰', '专辑', '流行', '/music/林俊杰 - 茉莉雨.mp3', '/images/music/moliyu.jpg', 220, 4500, 280);

-- 插入测试文章数据
INSERT INTO `articles` (`title`, `content`, `summary`, `category`, `tags`, `author_id`, `cover_image`, `views`, `likes`) VALUES
('Spring Boot 入门教程', '这是一篇关于 Spring Boot 的入门教程...', 'Spring Boot 是一个优秀的 Java 框架', '技术', 'Java,Spring Boot,后端', 1, '/images/articles/springboot.jpg', 800, 45),
('Vue.js 实战指南', '本文将介绍 Vue.js 的实战应用...', 'Vue.js 是一个渐进式的前端框架', '技术', 'Vue.js,前端,JavaScript', 1, '/images/articles/vuejs.jpg', 650, 38),
('个人博客搭建心得', '分享我搭建个人博客的经验和心得...', '记录搭建个人博客的过程和思考', '生活', '博客,心得,分享', 2, '/images/articles/blog.jpg', 420, 28);

-- 插入测试评论数据
INSERT INTO `comments` (`article_id`, `user_id`, `content`, `likes`) VALUES
(1, 2, '这篇文章写得很好，对新手很有帮助！', 5),
(1, 1, '感谢支持，后续会继续更新相关内容', 2),
(2, 2, 'Vue.js 确实是个不错的框架', 3),
(3, 1, '期待更多的分享', 1);

-- 创建索引以提高查询性能
CREATE INDEX idx_articles_created_at ON articles(created_at DESC);
CREATE INDEX idx_games_views ON games(views DESC);
CREATE INDEX idx_music_play_count ON music(play_count DESC);
CREATE INDEX idx_comments_created_at ON comments(created_at DESC);

-- 显示创建结果
SELECT 'Database and tables created successfully!' as message;