# 个人博客项目宝塔面板部署操作手册

## 📖 手册说明

本手册将指导您完成从本地项目打包到阿里云宝塔面板部署的完整流程。每个步骤都包含详细的操作说明和必要的代码。

## 🎯 部署目标

- **前端**: Vue3 静态文件部署
- **后端**: Spring Boot JAR包部署
- **数据库**: MySQL Docker容器部署
- **Web服务器**: Nginx反向代理
- **管理平台**: 宝塔面板

---

## 第一阶段：本地项目打包

### 步骤1：环境检查

#### 1.1 检查Node.js环境
```bash
# 检查Node.js版本（需要16+）
node --version

# 检查npm版本
npm --version
```

#### 1.2 检查Java环境
```bash
# 检查Java版本（需要JDK 8+）
java -version

# 检查Maven版本
mvn --version
```

### 步骤2：执行自动化构建

#### 2.1 Windows系统
```cmd
# 进入项目根目录
cd E:\学校\江西财经大学现代经济管理学院\实训\html转vue实战\aliyun_blog

# 执行构建脚本
build-for-baota.bat
```

#### 2.2 Linux/Mac系统
```bash
# 进入项目根目录
cd /path/to/aliyun_blog

# 给脚本执行权限
chmod +x build-for-baota.sh

# 执行构建脚本
./build-for-baota.sh
```

### 步骤3：验证构建结果

构建完成后，检查 `build-output` 目录结构：

```
build-output/
├── frontend/              # 前端静态文件
│   ├── index.html
│   ├── static/
│   ├── games/
│   ├── images/
│   ├── music/
│   └── videos/
├── backend/               # 后端文件
│   └── blog-backend-1.0.0.jar
├── config/                # 配置文件
│   ├── application-prod.yml
│   └── docker-compose.yml
├── scripts/               # 启动脚本
│   ├── start.sh
│   ├── stop.sh
│   ├── start-mysql.sh
│   └── backup.sh
├── sql/                   # 数据库脚本
│   ├── 创建结构.sql
│   └── 插入测试数据.sql
└── README.md              # 部署说明
```

### 步骤4：打包上传文件

#### 4.1 创建压缩包（如果自动构建未创建）
```bash
# Windows
cd build-output
tar -czf ../personal-blog-deploy.tar.gz *

# Linux
cd build-output
tar -czf ../personal-blog-deploy.tar.gz *
```

---

## 第二阶段：服务器环境准备

### 步骤5：登录宝塔面板

1. 打开浏览器访问宝塔面板地址
2. 输入用户名和密码登录
3. 确认面板版本和功能正常

### 步骤6：安装必要软件

#### 6.1 安装Docker
```bash
# 在宝塔面板终端中执行
# 或通过宝塔面板软件商店安装Docker

# 手动安装命令
curl -fsSL https://get.docker.com -o get-docker.sh
sudo sh get-docker.sh

# 启动Docker服务
sudo systemctl start docker
sudo systemctl enable docker

# 验证安装
docker --version
```

#### 6.2 确认Nginx已安装
- 在宝塔面板「软件商店」中确认Nginx已安装
- 如未安装，点击安装Nginx

### 步骤7：创建项目目录

#### 7.1 通过宝塔面板文件管理器创建
1. 进入「文件」管理
2. 导航到 `/www/wwwroot/`
3. 创建 `personal-blog` 目录
4. 在 `personal-blog` 下创建以下子目录：

```bash
# 或通过终端创建
sudo mkdir -p /www/wwwroot/personal-blog/{frontend,backend,config,scripts,uploads/{articles,avatars,comments},logs,sql}

# 设置权限
sudo chown -R www:www /www/wwwroot/personal-blog
sudo chmod -R 755 /www/wwwroot/personal-blog
```

### 步骤8：上传项目文件

#### 8.1 上传压缩包
1. 在宝塔面板文件管理器中进入 `/www/wwwroot/personal-blog/`
2. 点击「上传」按钮
3. 选择 `personal-blog-deploy.tar.gz` 文件上传
4. 上传完成后，右键点击压缩包选择「解压」

#### 8.2 或分别上传文件
- 将 `build-output/frontend/` 内容上传到 `/www/wwwroot/personal-blog/frontend/`
- 将 `build-output/backend/` 内容上传到 `/www/wwwroot/personal-blog/backend/`
- 将 `build-output/config/` 内容上传到 `/www/wwwroot/personal-blog/config/`
- 将 `build-output/scripts/` 内容上传到 `/www/wwwroot/personal-blog/scripts/`
- 将 `build-output/sql/` 内容上传到 `/www/wwwroot/personal-blog/sql/`

#### 8.3 设置脚本执行权限
```bash
# 在宝塔面板终端中执行
chmod +x /www/wwwroot/personal-blog/scripts/*.sh
```

---

## 第三阶段：数据库部署

### 步骤9：启动MySQL容器

#### 9.1 执行MySQL启动脚本
```bash
# 进入脚本目录
cd /www/wwwroot/personal-blog/scripts

# 执行MySQL启动脚本
./start-mysql.sh
```

#### 9.2 手动启动MySQL容器（如脚本失败）
```bash
# 创建数据卷
docker volume create personal-blog-mysql-data

# 启动MySQL容器
docker run -d \
  --name personal-blog-mysql \
  --restart always \
  -e MYSQL_ROOT_PASSWORD=root123456 \
  -e MYSQL_DATABASE=musicgame_db \
  -e MYSQL_USER=musicgame_user \
  -e MYSQL_PASSWORD=musicgame123 \
  -p 3306:3306 \
  -v personal-blog-mysql-data:/var/lib/mysql \
  mysql:8.0.36 \
  --default-authentication-plugin=mysql_native_password
```

#### 9.3 验证MySQL容器状态
```bash
# 检查容器状态
docker ps | grep personal-blog-mysql

# 查看容器日志
docker logs personal-blog-mysql
```

### 步骤10：初始化数据库

#### 10.1 导入数据库结构
```bash
# 等待MySQL完全启动（约30秒）
sleep 30

# 导入数据库结构
docker exec -i personal-blog-mysql mysql -u musicgame_user -pmusicgame123 musicgame_db < /www/wwwroot/personal-blog/sql/创建结构.sql
```

#### 10.2 导入测试数据（可选）
```bash
# 导入测试数据
docker exec -i personal-blog-mysql mysql -u musicgame_user -pmusicgame123 musicgame_db < /www/wwwroot/personal-blog/sql/插入测试数据.sql
```

#### 10.3 验证数据库
```bash
# 连接数据库检查
docker exec -it personal-blog-mysql mysql -u musicgame_user -pmusicgame123 musicgame_db

# 在MySQL命令行中执行
SHOW TABLES;
SELECT COUNT(*) FROM users;
SELECT COUNT(*) FROM articles;
exit
```

---

## 第四阶段：Web服务器配置

### 步骤11：创建网站

#### 11.1 在宝塔面板中添加站点
1. 进入宝塔面板「网站」页面
2. 点击「添加站点」
3. 填写以下信息：
   - **域名**: `likeusewin10.xyz`
   - **根目录**: `/www/wwwroot/personal-blog/frontend`
   - **PHP版本**: 不选择（静态站点）
4. 点击「提交」创建站点

### 步骤12：配置Nginx

#### 12.1 编辑站点配置
1. 在「网站」列表中找到刚创建的站点
2. 点击「设置」
3. 选择「配置文件」标签
4. 将配置内容替换为以下内容：

```nginx
server {
    listen 80;
    server_name likeusewin10.xyz;
    root /www/wwwroot/personal-blog/frontend;
    index index.html;
    
    # 客户端最大上传文件大小
    client_max_body_size 10M;
    
    # 前端静态文件
    location / {
        try_files $uri $uri/ /index.html;
        
        # 静态文件缓存
        location ~* \.(js|css|png|jpg|jpeg|gif|ico|svg|woff|woff2|ttf|eot)$ {
            expires 1y;
            add_header Cache-Control "public, immutable";
        }
    }
    
    # API代理到后端
    location /api/ {
        proxy_pass http://127.0.0.1:8080/api/;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
        
        # 超时设置
        proxy_connect_timeout 60s;
        proxy_send_timeout 60s;
        proxy_read_timeout 60s;
    }
    
    # 上传文件访问
    location /uploads/ {
        alias /www/wwwroot/personal-blog/uploads/;
        expires 1d;
        add_header Cache-Control "public";
    }
    
    # Gzip压缩
    gzip on;
    gzip_vary on;
    gzip_min_length 1024;
    gzip_types text/plain text/css text/xml text/javascript application/javascript application/xml+rss application/json;
    
    # 安全头
    add_header X-Frame-Options "SAMEORIGIN" always;
    add_header X-XSS-Protection "1; mode=block" always;
    add_header X-Content-Type-Options "nosniff" always;
    
    # 访问日志
    access_log /www/wwwlogs/personal-blog.log;
    error_log /www/wwwlogs/personal-blog.error.log;
}
```

#### 12.2 测试并重载Nginx配置
```bash
# 测试配置语法
nginx -t

# 重新加载配置
nginx -s reload
```

---

## 第五阶段：后端应用部署

### 步骤13：配置应用环境

#### 13.1 检查Java环境
```bash
# 检查Java版本
java -version

# 如果没有Java，安装OpenJDK 8
sudo apt update
sudo apt install openjdk-8-jdk -y

# 设置JAVA_HOME
echo 'export JAVA_HOME=/usr/lib/jvm/java-8-openjdk-amd64' >> ~/.bashrc
source ~/.bashrc
```

#### 13.2 修改配置文件（如需要）
编辑 `/www/wwwroot/personal-blog/config/application-prod.yml`：

```yaml
server:
  port: 8080
  servlet:
    context-path: /api

spring:
  datasource:
    url: jdbc:mysql://localhost:3306/musicgame_db?useUnicode=true&characterEncoding=utf8&zeroDateTimeBehavior=convertToNull&useSSL=false&serverTimezone=GMT%2B8
    username: musicgame_user
    password: musicgame123
    driver-class-name: com.mysql.cj.jdbc.Driver
  
  servlet:
    multipart:
      max-file-size: 10MB
      max-request-size: 10MB

# 文件上传路径配置
file:
  upload:
    path: /www/wwwroot/personal-blog/uploads/

# 日志配置
logging:
  level:
    com.likeusewin10: DEBUG
  file:
    name: /www/wwwroot/personal-blog/logs/application.log
  pattern:
    file: "%d{yyyy-MM-dd HH:mm:ss} [%thread] %-5level %logger{36} - %msg%n"

# MyBatis Plus配置
mybatis-plus:
  configuration:
    log-impl: org.apache.ibatis.logging.stdout.StdOutImpl
  global-config:
    db-config:
      logic-delete-field: deleted
      logic-delete-value: 1
      logic-not-delete-value: 0
```

### 步骤14：启动后端服务

#### 14.1 使用启动脚本
```bash
# 进入后端目录
cd /www/wwwroot/personal-blog/backend

# 复制启动脚本到当前目录
cp ../scripts/start.sh .
cp ../scripts/stop.sh .

# 启动服务
./start.sh
```

#### 14.2 手动启动（如脚本失败）
```bash
# 进入后端目录
cd /www/wwwroot/personal-blog/backend

# 启动应用
nohup java -Xms512m -Xmx1024m -XX:+UseG1GC -jar blog-backend-1.0.0.jar --spring.profiles.active=prod --spring.config.location=/www/wwwroot/personal-blog/config/application-prod.yml > /www/wwwroot/personal-blog/logs/startup.log 2>&1 &

# 记录进程ID
echo $! > /tmp/personal-blog-backend.pid
```

#### 14.3 验证服务启动
```bash
# 检查进程
ps aux | grep java

# 检查端口监听
netstat -tlnp | grep :8080

# 查看启动日志
tail -f /www/wwwroot/personal-blog/logs/startup.log
```

---

## 第六阶段：功能测试

### 步骤15：基础连通性测试

#### 15.1 测试前端访问
```bash
# 测试前端页面
curl -I http://likeusewin10.xyz

# 应该返回 200 OK
```

#### 15.2 测试后端API
```bash
# 测试健康检查接口
curl http://likeusewin10.xyz/api/health

# 测试文章列表接口
curl http://likeusewin10.xyz/api/articles
```

#### 15.3 测试数据库连接
```bash
# 进入MySQL容器测试
docker exec -it personal-blog-mysql mysql -u musicgame_user -pmusicgame123 -e "SELECT 1;"
```

### 步骤16：完整功能测试

#### 16.1 浏览器测试
1. 打开浏览器访问 `http://likeusewin10.xyz`
2. 检查以下功能：
   - [ ] 首页正常加载
   - [ ] 导航菜单正常工作
   - [ ] 各个页面可以正常跳转
   - [ ] 静态资源（图片、CSS、JS）正常加载

#### 16.2 API功能测试
使用以下测试脚本：

```bash
# 创建API测试脚本
cat > /www/wwwroot/personal-blog/test-api.sh << 'EOF'
#!/bin/bash

BASE_URL="http://likeusewin10.xyz/api"

echo "=== API功能测试 ==="

# 测试健康检查
echo "1. 测试健康检查接口"
curl -s "$BASE_URL/health" | head -c 100
echo -e "\n"

# 测试文章列表
echo "2. 测试文章列表接口"
curl -s "$BASE_URL/articles" | head -c 200
echo -e "\n"

# 测试用户注册（示例）
echo "3. 测试用户注册接口"
curl -X POST -H "Content-Type: application/json" \
  -d '{"username":"testuser","email":"test@example.com","password":"123456"}' \
  "$BASE_URL/auth/register" | head -c 200
echo -e "\n"

echo "=== 测试完成 ==="
EOF

# 执行测试
chmod +x /www/wwwroot/personal-blog/test-api.sh
./test-api.sh
```

---

## 第七阶段：系统服务配置

### 步骤17：配置开机自启动

#### 17.1 创建systemd服务文件
```bash
# 创建服务文件
sudo tee /etc/systemd/system/personal-blog.service > /dev/null << 'EOF'
[Unit]
Description=Personal Blog Backend Service
After=network.target docker.service
Requires=docker.service

[Service]
Type=forking
User=root
WorkingDirectory=/www/wwwroot/personal-blog/backend
ExecStart=/www/wwwroot/personal-blog/scripts/start.sh
ExecStop=/www/wwwroot/personal-blog/scripts/stop.sh
Restart=always
RestartSec=10

[Install]
WantedBy=multi-user.target
EOF
```

#### 17.2 启用并启动服务
```bash
# 重新加载systemd配置
sudo systemctl daemon-reload

# 启用服务
sudo systemctl enable personal-blog

# 启动服务
sudo systemctl start personal-blog

# 检查服务状态
sudo systemctl status personal-blog
```

### 步骤18：配置定时备份

#### 18.1 设置备份定时任务
```bash
# 编辑crontab
crontab -e

# 添加以下行（每天凌晨2点备份）
0 2 * * * /www/wwwroot/personal-blog/scripts/backup.sh

# 保存并退出
```

#### 18.2 测试备份脚本
```bash
# 手动执行备份测试
/www/wwwroot/personal-blog/scripts/backup.sh

# 检查备份文件
ls -la /www/backup/personal-blog/
```

---

## 第八阶段：安全配置

### 步骤19：配置防火墙

#### 19.1 宝塔面板防火墙设置
1. 进入宝塔面板「安全」页面
2. 添加以下端口规则：
   - 端口 `80` - HTTP访问
   - 端口 `443` - HTTPS访问（如需要）
   - 端口 `8888` - 宝塔面板
3. 删除不必要的端口开放

#### 19.2 系统防火墙配置（可选）
```bash
# 安装ufw防火墙
sudo apt install ufw -y

# 配置防火墙规则
sudo ufw default deny incoming
sudo ufw default allow outgoing
sudo ufw allow ssh
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp
sudo ufw allow 8888/tcp

# 启用防火墙
sudo ufw enable

# 查看状态
sudo ufw status
```

### 步骤20：SSL证书配置（可选）

#### 20.1 通过宝塔面板申请SSL证书
1. 在网站设置中选择「SSL」标签
2. 选择「Let's Encrypt」免费证书
3. 填写域名信息并申请
4. 开启「强制HTTPS」

#### 20.2 手动申请SSL证书
```bash
# 安装certbot
sudo apt install certbot python3-certbot-nginx -y

# 申请证书
sudo certbot --nginx -d likeusewin10.xyz

# 设置自动续期
sudo crontab -e
# 添加：0 12 * * * /usr/bin/certbot renew --quiet
```

---

## 第九阶段：监控和维护

### 步骤21：设置监控

#### 21.1 创建监控脚本
```bash
# 创建服务监控脚本
cat > /www/wwwroot/personal-blog/scripts/monitor.sh << 'EOF'
#!/bin/bash

LOG_FILE="/www/wwwroot/personal-blog/logs/monitor.log"
DATE=$(date '+%Y-%m-%d %H:%M:%S')

echo "[$DATE] 开始系统监控检查" >> $LOG_FILE

# 检查MySQL容器
if ! docker ps | grep -q personal-blog-mysql; then
    echo "[$DATE] 警告: MySQL容器未运行" >> $LOG_FILE
    # 可以添加重启逻辑或发送告警
fi

# 检查后端服务
if ! ps aux | grep -q "blog-backend-1.0.0.jar"; then
    echo "[$DATE] 警告: 后端服务未运行" >> $LOG_FILE
    # 可以添加重启逻辑或发送告警
fi

# 检查磁盘空间
DISK_USAGE=$(df -h /www | awk 'NR==2 {print $5}' | sed 's/%//')
if [ $DISK_USAGE -gt 80 ]; then
    echo "[$DATE] 警告: 磁盘使用率超过80%: ${DISK_USAGE}%" >> $LOG_FILE
fi

# 检查内存使用
MEM_USAGE=$(free | awk 'NR==2{printf "%.0f", $3*100/$2}')
if [ $MEM_USAGE -gt 80 ]; then
    echo "[$DATE] 警告: 内存使用率超过80%: ${MEM_USAGE}%" >> $LOG_FILE
fi

echo "[$DATE] 监控检查完成" >> $LOG_FILE
EOF

# 设置执行权限
chmod +x /www/wwwroot/personal-blog/scripts/monitor.sh
```

#### 21.2 设置监控定时任务
```bash
# 编辑crontab
crontab -e

# 添加监控任务（每5分钟检查一次）
*/5 * * * * /www/wwwroot/personal-blog/scripts/monitor.sh
```

### 步骤22：日志管理

#### 22.1 创建日志清理脚本
```bash
# 创建日志清理脚本
cat > /www/wwwroot/personal-blog/scripts/cleanup-logs.sh << 'EOF'
#!/bin/bash

LOG_DIR="/www/wwwroot/personal-blog/logs"
DATE=$(date '+%Y-%m-%d %H:%M:%S')

echo "[$DATE] 开始清理日志文件"

# 清理7天前的日志文件
find $LOG_DIR -name "*.log" -mtime +7 -delete

# 清理Docker日志
docker system prune -f --filter "until=168h"

echo "[$DATE] 日志清理完成"
EOF

# 设置执行权限
chmod +x /www/wwwroot/personal-blog/scripts/cleanup-logs.sh

# 添加到定时任务（每周执行一次）
crontab -e
# 添加：0 3 * * 0 /www/wwwroot/personal-blog/scripts/cleanup-logs.sh
```

---

## 第十阶段：故障排除

### 常见问题解决方案

#### 问题1：前端页面无法访问

**诊断命令：**
```bash
# 检查Nginx状态
sudo systemctl status nginx

# 检查Nginx配置
nginx -t

# 检查网站文件
ls -la /www/wwwroot/personal-blog/frontend/

# 检查Nginx日志
tail -f /www/wwwlogs/personal-blog.error.log
```

**解决方案：**
1. 重启Nginx：`sudo systemctl restart nginx`
2. 检查文件权限：`sudo chmod -R 755 /www/wwwroot/personal-blog/frontend/`
3. 检查域名解析

#### 问题2：后端API无法访问

**诊断命令：**
```bash
# 检查Java进程
ps aux | grep java

# 检查端口监听
netstat -tlnp | grep :8080

# 查看应用日志
tail -f /www/wwwroot/personal-blog/logs/application.log

# 查看启动日志
tail -f /www/wwwroot/personal-blog/logs/startup.log
```

**解决方案：**
1. 重启后端服务：`/www/wwwroot/personal-blog/scripts/stop.sh && /www/wwwroot/personal-blog/scripts/start.sh`
2. 检查配置文件
3. 检查数据库连接

#### 问题3：数据库连接失败

**诊断命令：**
```bash
# 检查MySQL容器
docker ps | grep mysql

# 查看容器日志
docker logs personal-blog-mysql

# 测试数据库连接
docker exec -it personal-blog-mysql mysql -u musicgame_user -pmusicgame123
```

**解决方案：**
1. 重启MySQL容器：`docker restart personal-blog-mysql`
2. 检查数据库配置
3. 重新创建容器

#### 问题4：文件上传失败

**诊断命令：**
```bash
# 检查上传目录权限
ls -la /www/wwwroot/personal-blog/uploads/

# 检查磁盘空间
df -h

# 检查Nginx配置中的文件大小限制
grep client_max_body_size /www/server/panel/vhost/nginx/likeusewin10.xyz.conf
```

**解决方案：**
1. 设置正确权限：`sudo chmod -R 755 /www/wwwroot/personal-blog/uploads/`
2. 增加文件大小限制
3. 清理磁盘空间

---

## 📋 部署完成检查清单

### 基础环境
- [ ] 宝塔面板正常运行
- [ ] Docker已安装并运行
- [ ] Nginx已安装并运行
- [ ] Java环境配置正确

### 数据库
- [ ] MySQL容器正常运行
- [ ] 数据库结构导入成功
- [ ] 数据库连接测试通过
- [ ] 测试数据导入（可选）

### 应用服务
- [ ] 前端文件部署完成
- [ ] 后端服务正常启动
- [ ] API接口响应正常
- [ ] 文件上传功能正常

### Web服务器
- [ ] 网站创建成功
- [ ] Nginx配置正确
- [ ] 反向代理工作正常
- [ ] 静态文件访问正常

### 系统服务
- [ ] 开机自启动配置
- [ ] 定时备份配置
- [ ] 监控脚本配置
- [ ] 日志管理配置

### 安全配置
- [ ] 防火墙规则配置
- [ ] SSL证书配置（可选）
- [ ] 访问权限设置
- [ ] 安全头配置

### 功能测试
- [ ] 前端页面正常访问
- [ ] 用户注册登录功能
- [ ] 文章浏览和搜索
- [ ] 评论功能
- [ ] 音乐播放功能
- [ ] 游戏视频功能

---

## 🎉 部署完成

### 访问地址
- **网站首页**: http://likeusewin10.xyz
- **API接口**: http://likeusewin10.xyz/api
- **宝塔面板**: http://服务器IP:8888

### 管理命令

```bash
# 启动所有服务
sudo systemctl start personal-blog

# 停止所有服务
sudo systemctl stop personal-blog

# 重启所有服务
sudo systemctl restart personal-blog

# 查看服务状态
sudo systemctl status personal-blog

# 查看实时日志
tail -f /www/wwwroot/personal-blog/logs/application.log

# 手动备份
/www/wwwroot/personal-blog/scripts/backup.sh

# 系统监控
/www/wwwroot/personal-blog/scripts/monitor.sh
```

### 维护建议

1. **定期检查**：每周检查系统状态和日志
2. **备份验证**：定期验证备份文件完整性
3. **安全更新**：及时更新系统和应用安全补丁
4. **性能监控**：关注系统资源使用情况
5. **日志分析**：定期分析访问日志和错误日志

---

**🎊 恭喜！您已成功完成个人博客项目的宝塔面板部署！**

如有问题，请参考故障排除章节或查看相关日志文件。