# 🚀 个人博客项目快速启动指南

## 📋 部署前检查清单

### ✅ 服务器环境
- [ ] 阿里云ECS服务器已准备就绪
- [ ] 服务器IP: `47.86.42.89:31176`
- [ ] 域名: `likeusewin10.xyz` 已解析到服务器
- [ ] MySQL数据库已通过Docker部署

### ✅ 本地环境
- [ ] Node.js 16+ 已安装
- [ ] Maven 3.6+ 已安装
- [ ] Java JDK 1.8.0——371 已安装
- [ ] Docker 和 Docker Compose 已安装

## 🎯 一键部署（推荐）

### Windows 用户
```cmd
# 1. 打开命令提示符，进入项目目录
cd E:\学校\江西财经大学现代经济管理学院\实训\html转vue实战\trace

# 2. 执行一键部署脚本
deploy.bat
```

### Linux/Mac 用户
```bash
# 1. 进入项目目录
cd /path/to/personal-blog

# 2. 给脚本添加执行权限
chmod +x deploy.sh

# 3. 执行一键部署脚本
./deploy.sh
```

## 📝 手动部署步骤

如果自动化脚本遇到问题，可以按以下步骤手动部署：

### 1️⃣ 构建前端
```bash
cd Vue3
npm install
npm run build
cd ..
```

### 2️⃣ 构建后端
```bash
cd backend
mvn clean package -DskipTests
cd ..
```

### 3️⃣ 启动服务
```bash
# 创建必要目录
mkdir -p uploads logs

# 创建数据卷
docker volume create musicgame-mysql-data

# 启动所有服务
docker-compose up -d --build
```

## 🔍 部署验证

### 检查服务状态
```bash
# 查看容器状态
docker-compose ps

# 应该看到三个服务都是 Up 状态：
# personal-blog-mysql     Up
# personal-blog-backend   Up  
# personal-blog-frontend  Up
```

### 访问测试
1. **前端页面**: http://likeusewin10.xyz
2. **后端API**: http://likeusewin10.xyz/api/health
3. **健康检查**: http://likeusewin10.xyz/api/health/simple

## 🎉 功能验证

部署成功后，请验证以下功能：

### ✅ 前端页面
- [ ] 首页 - 个人信息展示
- [ ] 代码页面 - 编程内容展示  
- [ ] 游戏页面 - 游戏视频分类展示
- [ ] 音乐页面 - 音乐播放列表
- [ ] 论坛页面 - 文章列表和搜索
- [ ] 登录注册 - 用户认证功能

### ✅ 后端API
- [ ] 健康检查: `/api/health`
- [ ] 用户注册: `/api/auth/register`
- [ ] 用户登录: `/api/auth/login`
- [ ] 游戏列表: `/api/games`
- [ ] 音乐列表: `/api/music`
- [ ] 文章列表: `/api/articles`

## 🛠️ 常见问题快速解决

### 问题1: 端口被占用
```bash
# 检查端口占用
netstat -tlnp | grep :80
netstat -tlnp | grep :3306

# 停止占用服务
sudo systemctl stop apache2
sudo systemctl stop nginx
```

### 问题2: Docker 权限问题
```bash
# 添加用户到 docker 组
sudo usermod -aG docker $USER

# 重新登录或执行
newgrp docker
```

### 问题3: 数据库连接失败
```bash
# 检查数据库容器
docker logs personal-blog-mysql

# 重启数据库服务
docker-compose restart mysql
```

### 问题4: 前端页面无法访问
```bash
# 检查 Nginx 配置
docker logs personal-blog-frontend

# 重启前端服务
docker-compose restart frontend
```

## 📊 监控和维护

### 查看日志
```bash
# 查看所有服务日志
docker-compose logs -f

# 查看特定服务日志
docker-compose logs backend
docker-compose logs frontend
docker-compose logs mysql
```

### 重启服务
```bash
# 重启所有服务
docker-compose restart

# 重启特定服务
docker-compose restart backend
```

### 停止服务
```bash
# 停止所有服务
docker-compose down

# 停止并删除数据
docker-compose down -v
```

## 🔧 配置文件说明

### 重要配置文件
- `docker-compose.yml` - Docker 服务编排
- `nginx/conf.d/default.conf` - Nginx 配置
- `backend/src/main/resources/application-prod.yml` - 生产环境配置
- `Vue3/vue.config.js` - 前端构建配置

### 数据库配置
```yaml
# 数据库连接信息
url: jdbc:mysql://mysql:3306/musicgame_db
username: musicgame_user
password: musicgame123
```

## 📞 获取帮助

如果遇到问题：

1. **查看详细部署指南**: `部署指南.md`
2. **检查日志文件**: `logs/personal-blog.log`
3. **查看容器日志**: `docker-compose logs`
4. **健康检查**: 访问 `/api/health` 接口

## 🎊 部署成功！

恭喜！您的个人博客系统已成功部署到阿里云服务器。

**访问地址**:
- 🌐 网站首页: http://likeusewin10.xyz
- 🔧 API接口: http://likeusewin10.xyz/api
- 💓 健康检查: http://likeusewin10.xyz/api/health

**下一步**:
1. 注册管理员账户
2. 上传游戏视频和音乐文件
3. 发布第一篇博客文章
4. 配置SSL证书（可选）
5. 设置定期备份

---

**祝您使用愉快！** 🎉✨