# 邮件配置指南

## 概述

个人博客系统现在支持真实邮件发送功能，用于忘记密码时发送验证码。系统会自动检测邮件配置是否完整：
- 如果配置完整，将发送真实邮件
- 如果配置不完整，将在控制台显示验证码（开发模式）

## QQ邮箱配置步骤

### 1. 开启QQ邮箱SMTP服务

1. 登录QQ邮箱 (https://mail.qq.com)
2. 点击「设置」→「账户」
3. 找到「POP3/IMAP/SMTP/Exchange/CardDAV/CalDAV服务」
4. 开启「IMAP/SMTP服务」
5. 按照提示发送短信，获取**授权码**（不是QQ密码！）

### 2. 修改配置文件

编辑 `backend/src/main/resources/application.yml` 文件：

```yaml
spring:
  mail:
    host: smtp.qq.com
    port: 587
    username: your-email@qq.com  # 替换为你的QQ邮箱
    password: your-auth-code     # 替换为你的QQ邮箱授权码
    properties:
      mail:
        smtp:
          auth: true
          starttls:
            enable: true
            required: true
          ssl:
            trust: smtp.qq.com
```

**重要说明：**
- `username`: 填写你的完整QQ邮箱地址
- `password`: 填写第1步获取的**授权码**，不是QQ密码

### 3. 重启服务

修改配置后需要重启后端服务：

```bash
# 停止当前服务
# 重新启动
mvn spring-boot:run
```

## 其他邮箱配置

### 163邮箱

```yaml
spring:
  mail:
    host: smtp.163.com
    port: 587
    username: your-email@163.com
    password: your-auth-code
    properties:
      mail:
        smtp:
          auth: true
          starttls:
            enable: true
```

### Gmail邮箱

```yaml
spring:
  mail:
    host: smtp.gmail.com
    port: 587
    username: your-email@gmail.com
    password: your-app-password  # 需要开启两步验证并生成应用密码
    properties:
      mail:
        smtp:
          auth: true
          starttls:
            enable: true
```

## 测试邮件发送

配置完成后，可以通过以下方式测试：

1. 启动后端服务
2. 在前端或通过API测试忘记密码功能
3. 检查目标邮箱是否收到验证码邮件
4. 查看后端控制台日志确认发送状态

## 常见问题

### Q: 提示"535 Login Fail"错误
A: 检查邮箱地址和授权码是否正确，确保使用的是授权码而不是登录密码。

### Q: 提示连接超时
A: 检查网络连接，确保服务器可以访问SMTP服务器。

### Q: 邮件发送失败但系统正常运行
A: 系统有备用方案，邮件发送失败时会在控制台显示验证码，不影响功能使用。

### Q: 如何在生产环境中配置
A: 建议使用环境变量或配置文件管理敏感信息：

```yaml
spring:
  mail:
    username: ${MAIL_USERNAME:your-email@qq.com}
    password: ${MAIL_PASSWORD:your-auth-code}
```

## 安全建议

1. **不要将邮箱密码/授权码提交到版本控制系统**
2. 在生产环境中使用环境变量管理敏感配置
3. 定期更换邮箱授权码
4. 考虑使用专门的邮件服务提供商（如阿里云邮件推送、腾讯云邮件服务等）

## 邮件模板自定义

如需自定义邮件内容，可以修改 `EmailServiceImpl.java` 中的 `sendRealEmail` 方法：

```java
message.setSubject("你的网站名 - 验证码");
message.setText("自定义邮件内容...");
```

---

**注意：** 当前系统使用内存存储验证码，重启服务后验证码会丢失。生产环境建议使用Redis等持久化存储。