# 个人博客项目阿里云部署指南

## 项目概述

本项目是一个基于 Vue3 + Spring Boot + MySQL 的个人博客系统，支持文章发布、游戏视频展示、音乐播放等功能。

### 技术栈
- **前端**: Vue3 + Vue Router
- **后端**: Spring Boot 2.7 + MyBatis Plus + Spring Security
- **数据库**: MySQL 8.0.36
- **部署**: Docker + Docker Compose + Nginx

## 服务器环境要求

### 硬件要求
- **CPU**: 2核心以上
- **内存**: 4GB以上
- **存储**: 20GB以上可用空间
- **网络**: 公网IP和域名

### 软件要求
- **操作系统**: Linux (推荐 Ubuntu 20.04+)
- **Docker**: 20.10+
- **Docker Compose**: 1.29+
- **Node.js**: 16+
- **Maven**: 3.6+
- **Java**: JDK 8+

## 部署前准备

### 1. 服务器信息确认
```bash
# 服务器配置
公网IP: 47.86.42.89:31176
域名: likeusewin10.xyz
数据库: MySQL 8.0.36 (Docker)
```

### 2. 安装必要软件

#### 安装 Docker
```bash
# 更新系统
sudo apt update
sudo apt upgrade -y

# 安装 Docker
curl -fsSL https://get.docker.com -o get-docker.sh
sudo sh get-docker.sh

# 启动 Docker 服务
sudo systemctl start docker
sudo systemctl enable docker

# 添加用户到 docker 组
sudo usermod -aG docker $USER
```

#### 安装 Docker Compose
```bash
# 下载 Docker Compose
sudo curl -L "https://github.com/docker/compose/releases/download/v2.20.0/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose

# 添加执行权限
sudo chmod +x /usr/local/bin/docker-compose

# 验证安装
docker-compose --version
```

#### 安装 Node.js 和 npm
```bash
# 使用 NodeSource 仓库安装
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# 验证安装
node --version
npm --version
```

#### 安装 Maven
```bash
# 安装 Maven
sudo apt install maven -y

# 验证安装
mvn --version
```

#### 安装 Java JDK
```bash
# 安装 OpenJDK 8
sudo apt install openjdk-8-jdk -y

# 设置 JAVA_HOME
echo 'export JAVA_HOME=/usr/lib/jvm/java-8-openjdk-amd64' >> ~/.bashrc
source ~/.bashrc

# 验证安装
java -version
```

### 3. 上传项目文件

```bash
# 创建项目目录
sudo mkdir -p /opt/personal-blog
sudo chown $USER:$USER /opt/personal-blog
cd /opt/personal-blog

# 上传项目文件（使用 scp 或 git clone）
# 方式1: 使用 scp 上传
scp -r /path/to/local/project/* user@47.86.42.89:/opt/personal-blog/

# 方式2: 使用 git clone（如果代码在 git 仓库中）
# git clone https://github.com/your-username/personal-blog.git .
```

## 部署步骤

### 方式一：使用自动化部署脚本（推荐）

#### Linux 系统
```bash
# 进入项目目录
cd /opt/personal-blog

# 给脚本添加执行权限
chmod +x deploy.sh

# 执行部署脚本
./deploy.sh
```

#### Windows 系统
```cmd
# 进入项目目录
cd E:\学校\江西财经大学现代经济管理学院\实训\html转vue实战\trace

# 执行部署脚本
deploy.bat
```

### 方式二：手动部署

#### 1. 构建前端项目
```bash
# 进入前端目录
cd Vue3

# 安装依赖
npm install

# 构建项目
npm run build

# 返回项目根目录
cd ..
```

#### 2. 构建后端项目
```bash
# 进入后端目录
cd backend

# 清理并打包
mvn clean package -DskipTests

# 返回项目根目录
cd ..
```

#### 3. 准备部署环境
```bash
# 创建必要目录
mkdir -p uploads logs

# 创建 MySQL 数据卷
docker volume create musicgame-mysql-data
```

#### 4. 启动服务
```bash
# 启动所有服务
docker-compose up -d --build

# 查看服务状态
docker-compose ps

# 查看日志
docker-compose logs -f
```

## 配置说明

### 1. 数据库配置

数据库连接信息已在 `application-prod.yml` 中配置：
```yaml
spring:
  datasource:
    url: jdbc:mysql://mysql:3306/musicgame_db
    username: musicgame_user
    password: musicgame123
```

### 2. Nginx 配置

Nginx 配置文件位于 `nginx/conf.d/default.conf`，主要配置：
- 静态文件服务
- API 代理到后端
- 文件上传支持
- Gzip 压缩

### 3. Docker Compose 配置

`docker-compose.yml` 定义了三个服务：
- **mysql**: MySQL 数据库服务
- **backend**: Spring Boot 后端服务
- **frontend**: Nginx 前端服务

## 验证部署

### 1. 检查服务状态
```bash
# 查看容器状态
docker-compose ps

# 查看服务日志
docker-compose logs backend
docker-compose logs frontend
docker-compose logs mysql
```

### 2. 访问测试
```bash
# 测试前端
curl http://localhost
curl http://likeusewin10.xyz

# 测试后端 API
curl http://localhost:8080/api/health
curl http://likeusewin10.xyz/api/health

# 测试数据库连接
docker exec personal-blog-mysql mysqladmin ping -h localhost -u root -proot123456
```

### 3. 功能测试
1. 访问 `http://likeusewin10.xyz` 查看首页
2. 测试各个页面功能：
   - 首页：个人信息展示
   - 代码页面：编程内容展示
   - 游戏页面：游戏视频分类展示
   - 音乐页面：音乐播放列表
   - 论坛页面：文章列表和搜索
   - 登录注册：用户认证功能

## 常见问题解决

### 1. 端口冲突
```bash
# 检查端口占用
sudo netstat -tlnp | grep :80
sudo netstat -tlnp | grep :3306
sudo netstat -tlnp | grep :8081

# 停止占用端口的服务
sudo systemctl stop apache2  # 如果安装了 Apache
sudo systemctl stop nginx    # 如果安装了系统 Nginx
```

### 2. 权限问题
```bash
# 设置文件权限
sudo chown -R $USER:$USER /opt/personal-blog
chmod -R 755 /opt/personal-blog

# 设置上传目录权限
sudo chmod 777 uploads
```

### 3. 数据库连接失败
```bash
# 检查数据库容器状态
docker logs personal-blog-mysql

# 进入数据库容器
docker exec -it personal-blog-mysql mysql -u root -proot123456

# 检查数据库和用户
SHOW DATABASES;
SELECT user, host FROM mysql.user;
```

### 4. 内存不足
```bash
# 检查内存使用
free -h
docker stats

# 清理 Docker 资源
docker system prune -a
```

## 维护操作

### 1. 日常维护命令
```bash
# 查看服务状态
docker-compose ps

# 重启服务
docker-compose restart

# 停止服务
docker-compose down

# 更新服务
docker-compose pull
docker-compose up -d
```

### 2. 日志管理
```bash
# 查看实时日志
docker-compose logs -f

# 查看特定服务日志
docker-compose logs backend

# 清理日志
docker-compose logs --tail=0 -f
```

### 3. 数据备份
```bash
# 备份数据库
docker exec personal-blog-mysql mysqldump -u root -proot123456 musicgame_db > backup_$(date +%Y%m%d_%H%M%S).sql

# 备份上传文件
tar -czf uploads_backup_$(date +%Y%m%d_%H%M%S).tar.gz uploads/
```

### 4. 更新部署
```bash
# 拉取最新代码
git pull origin main

# 重新构建和部署
./deploy.sh

# 或者手动更新
docker-compose down
docker-compose up -d --build
```

## 性能优化

### 1. Nginx 优化
- 启用 Gzip 压缩
- 设置静态文件缓存
- 配置文件上传大小限制

### 2. 数据库优化
- 配置连接池参数
- 添加必要的索引
- 定期清理日志

### 3. 应用优化
- 配置 JVM 参数
- 启用应用缓存
- 监控应用性能

## 安全配置

### 1. 防火墙设置
```bash
# 安装 ufw
sudo apt install ufw

# 配置防火墙规则
sudo ufw default deny incoming
sudo ufw default allow outgoing
sudo ufw allow ssh
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp

# 启用防火墙
sudo ufw enable
```

### 2. SSL 证书配置（可选）
```bash
# 安装 Certbot
sudo apt install certbot python3-certbot-nginx

# 获取 SSL 证书
sudo certbot --nginx -d likeusewin10.xyz

# 自动续期
sudo crontab -e
# 添加：0 12 * * * /usr/bin/certbot renew --quiet
```

## 监控和日志

### 1. 系统监控
```bash
# 安装监控工具
sudo apt install htop iotop nethogs

# 监控系统资源
htop
df -h
free -h
```

### 2. 应用监控
```bash
# Docker 容器监控
docker stats

# 应用日志监控
tail -f logs/personal-blog.log
```

## 联系信息

如果在部署过程中遇到问题，可以：
1. 查看项目文档和日志
2. 检查 GitHub Issues
3. 联系项目维护者

---

**部署完成后访问地址**:
- 前端: http://likeusewin10.xyz
- 后端API: http://likeusewin10.xyz/api
- API文档: http://likeusewin10.xyz/api/swagger-ui/ (如果启用)

**祝您部署成功！** 🎉