# 个人博客项目需求分析和架构设计

## 项目概述
- **项目名称**: 个人博客系统 (Likeusewin10 Personal Blog)
- **技术栈**: Vue3 + SpringBoot + MySQL
- **部署环境**: 阿里云ECS

## 服务器配置信息
- **公网IP**: 47.86.42.89:31176
- **域名**: likeusewin10.xyz
- **数据库**: MySQL 8.0.36 (Docker部署)
- **数据库配置**:
  - ROOT密码: root123456
  - 数据库名: musicgame_db
  - 用户名: musicgame_user
  - 用户密码: musicgame123
  - 数据卷: musicgame-mysql-data

## 功能模块需求分析

### 1. 首页 (HomePage)
- **功能**: 个人信息展示
- **数据需求**: 本地头像地址
- **数据库**: 无需连接

### 2. 代码页面 (CodePage)
- **功能**: 展示编程相关内容
- **数据需求**: 本地视频地址
- **数据库**: 无需连接

### 3. 游戏页面 (GamePage)
- **功能**: 游戏视频展示和分类
- **数据需求**:
  - 游戏名称 (用于分类)
  - 游戏标题
  - 游戏详情
  - 游戏视频地址
- **业务逻辑**: 按游戏名分类展示，统计每个游戏的视频数量

### 4. 音乐页面 (MusicPage)
- **功能**: 音乐播放和管理
- **数据需求**:
  - 歌曲名
  - 歌手名
  - 时长
- **UI改进**: 
  - 标题统一风格
  - 全局播放器支持拖动

### 5. 论坛页面 (ForumPage)
- **功能**: 文章发布、浏览、搜索、评论
- **数据需求**:
  - 文章标题
  - 文章封面 (可选)
  - 文章正文
  - 评论内容 (支持图片)
- **权限控制**: 未登录用户只能查看，无法发表和评论

### 6. 登录注册页面 (LoginPage)
- **功能**: 用户认证和注册
- **数据需求**:
  - 用户昵称
  - 账号 (唯一)
  - 邮箱 (唯一)
  - 密码
  - 注册时间
- **业务逻辑**: 注册时检测账号和邮箱唯一性

## 数据库表设计

### 1. 用户表 (users)
```sql
CREATE TABLE users (
    id BIGINT PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(50) UNIQUE NOT NULL COMMENT '账号',
    nickname VARCHAR(100) NOT NULL COMMENT '昵称',
    email VARCHAR(100) UNIQUE NOT NULL COMMENT '邮箱',
    password VARCHAR(255) NOT NULL COMMENT '密码(加密)',
    avatar_url VARCHAR(500) COMMENT '头像地址',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT '注册时间',
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    status TINYINT DEFAULT 1 COMMENT '状态: 1-正常, 0-禁用'
);
```

### 2. 游戏表 (games)
```sql
CREATE TABLE games (
    id BIGINT PRIMARY KEY AUTO_INCREMENT,
    game_name VARCHAR(100) NOT NULL COMMENT '游戏名称',
    game_title VARCHAR(200) NOT NULL COMMENT '游戏标题',
    game_description TEXT COMMENT '游戏详情',
    video_url VARCHAR(500) NOT NULL COMMENT '游戏视频地址',
    thumbnail_url VARCHAR(500) COMMENT '缩略图地址',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    status TINYINT DEFAULT 1 COMMENT '状态: 1-显示, 0-隐藏'
);
```

### 3. 音乐表 (music)
```sql
CREATE TABLE music (
    id BIGINT PRIMARY KEY AUTO_INCREMENT,
    song_name VARCHAR(200) NOT NULL COMMENT '歌曲名',
    artist_name VARCHAR(100) NOT NULL COMMENT '歌手名',
    duration INT NOT NULL COMMENT '时长(秒)',
    audio_url VARCHAR(500) NOT NULL COMMENT '音频文件地址',
    cover_url VARCHAR(500) COMMENT '封面图片地址',
    album VARCHAR(100) COMMENT '专辑名',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    status TINYINT DEFAULT 1 COMMENT '状态: 1-显示, 0-隐藏'
);
```

### 4. 文章表 (articles)
```sql
CREATE TABLE articles (
    id BIGINT PRIMARY KEY AUTO_INCREMENT,
    title VARCHAR(200) NOT NULL COMMENT '文章标题',
    cover_url VARCHAR(500) COMMENT '封面图片地址',
    content LONGTEXT NOT NULL COMMENT '文章正文',
    summary TEXT COMMENT '文章摘要',
    author_id BIGINT NOT NULL COMMENT '作者ID',
    view_count INT DEFAULT 0 COMMENT '浏览次数',
    like_count INT DEFAULT 0 COMMENT '点赞次数',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    status TINYINT DEFAULT 1 COMMENT '状态: 1-发布, 0-草稿, -1-删除',
    FOREIGN KEY (author_id) REFERENCES users(id)
);
```

### 5. 评论表 (comments)
```sql
CREATE TABLE comments (
    id BIGINT PRIMARY KEY AUTO_INCREMENT,
    article_id BIGINT NOT NULL COMMENT '文章ID',
    user_id BIGINT NOT NULL COMMENT '评论用户ID',
    parent_id BIGINT COMMENT '父评论ID(回复功能)',
    content TEXT NOT NULL COMMENT '评论内容',
    image_urls JSON COMMENT '评论图片地址数组',
    like_count INT DEFAULT 0 COMMENT '点赞次数',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    status TINYINT DEFAULT 1 COMMENT '状态: 1-正常, 0-隐藏, -1-删除',
    FOREIGN KEY (article_id) REFERENCES articles(id),
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (parent_id) REFERENCES comments(id)
);
```

## 技术架构

### 前端 (Vue3)
- **框架**: Vue 3.2.13
- **路由**: Vue Router 4.5.1
- **状态管理**: Vuex 或 Pinia
- **HTTP客户端**: Axios
- **UI组件**: Element Plus 或自定义组件

### 后端 (SpringBoot)
- **框架**: Spring Boot 2.7+
- **数据访问**: MyBatis Plus
- **安全认证**: Spring Security + JWT
- **文件上传**: 本地存储或阿里云OSS
- **API文档**: Swagger/OpenAPI

### 数据库 (MySQL)
- **版本**: MySQL 8.0.36
- **部署**: Docker容器
- **连接池**: HikariCP

## API接口设计

### 用户相关
- POST /api/auth/register - 用户注册
- POST /api/auth/login - 用户登录
- GET /api/auth/profile - 获取用户信息
- PUT /api/auth/profile - 更新用户信息

### 游戏相关
- GET /api/games - 获取游戏列表
- GET /api/games/by-name/{gameName} - 按游戏名获取视频列表
- GET /api/games/stats - 获取游戏统计信息

### 音乐相关
- GET /api/music - 获取音乐列表
- GET /api/music/{id} - 获取音乐详情

### 文章相关
- GET /api/articles - 获取文章列表(支持搜索)
- GET /api/articles/{id} - 获取文章详情
- POST /api/articles - 发布文章(需登录)
- PUT /api/articles/{id} - 更新文章(需登录)
- DELETE /api/articles/{id} - 删除文章(需登录)

### 评论相关
- GET /api/comments/article/{articleId} - 获取文章评论
- POST /api/comments - 发表评论(需登录)
- DELETE /api/comments/{id} - 删除评论(需登录)

## 部署方案

### 前端部署
1. 构建Vue3项目: `npm run build`
2. 将dist目录上传到服务器
3. 使用Nginx代理静态文件和API请求

### 后端部署
1. 打包SpringBoot项目: `mvn clean package`
2. 上传jar文件到服务器
3. 使用systemd或Docker运行服务

### 数据库部署
1. MySQL已通过Docker部署
2. 执行数据库初始化脚本
3. 配置数据库连接参数

## 开发计划

### 阶段一: 后端开发
1. 创建SpringBoot项目
2. 配置数据库连接
3. 创建实体类和数据访问层
4. 实现用户认证和授权
5. 开发各模块API接口

### 阶段二: 前端改造
1. 集成HTTP客户端
2. 实现用户登录状态管理
3. 改造各页面组件对接API
4. 优化UI和用户体验

### 阶段三: 部署和测试
1. 配置生产环境
2. 部署前后端应用
3. 功能测试和性能优化
4. 上线和监控

## 注意事项

1. **安全性**: 密码加密、SQL注入防护、XSS防护
2. **性能**: 数据库索引优化、分页查询、缓存策略
3. **可扩展性**: 模块化设计、接口标准化
4. **用户体验**: 响应式设计、加载状态、错误处理
5. **SEO优化**: 服务端渲染或预渲染

---

**创建时间**: 2025年1月10日
**最后更新**: 2025年1月10日
**版本**: v1.0